% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-other.R
\name{newPlot}
\alias{newPlot}
\alias{dev.useRSGD}
\title{Open a new plotting window}
\usage{
newPlot(noRStudioGD = TRUE, ...)

dev.useRSGD(useRSGD = FALSE)
}
\arguments{
\item{noRStudioGD}{Logical Passed to dev.new. Default is TRUE to avoid using
RStudio graphics device, which is slow.}

\item{...}{Additional arguments.}

\item{useRSGD}{Logical indicating whether the default device should be the
RStudio graphic device, or the platform default (\code{quartz}
on macOS; \code{windows} on Windows; \code{x11} on others, e.g., Linux).}
}
\description{
Open a new plotting window
}
\note{
\code{\link{dev.new}} is supposed to be the correct way to open a new
window in a platform-generic way; however, doesn't work in RStudio
(\href{https://github.com/PredictiveEcology/SpaDES/issues/116}{SpaDES#116}).
Use \code{dev.useRSGD(FALSE)} to avoid RStudio for the remainder of this session,
and \code{dev.useRSGD(TRUE)} to use the RStudio graphics device.
(This sets the default device via the \code{device} option.)
}
\examples{
\dontrun{
  ## set option to avoid using Rstudio graphics device
  dev.useRSGD(FALSE)

  ## open new plotting window
  newPlot()
}

}
\seealso{
\code{\link{dev}}.
}
\author{
Eliot McIntire and Alex Chubaty
}
