% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_releases.R
\name{get_releases}
\alias{get_releases}
\title{Get PGS Catalog Releases}
\usage{
get_releases(
  date = "latest",
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{date}{One or more dates formatted as \code{"YYYY-MM-DD"} for respective
releases, \code{"latest"} for the latest release, or \code{"all"} for all
releases.}

\item{verbose}{Whether to print information about the underlying requests to
the REST API server.}

\item{warnings}{Whether to print warnings about the underlying requests to
the REST API server.}

\item{progress_bar}{Whether to show a progress bar indicating download
progress from the REST API server.}
}
\value{
A data frame where each row is a release. Columns are:
\describe{
\item{date}{Release date.}
\item{n_pgs}{Number of released Polygenic Score (PGS) identifiers
(\code{pgs_id}).}
\item{n_ppm}{Number of released Performance Metric (PPM) identifiers
(\code{ppm_id}).}
\item{n_pgp}{Number of released PGS Catalog Publication (PGP) identifiers
(\code{pgp_id}).}
\item{pgs_id}{Released Polygenic Score (PGS) identifiers.}
\item{ppm_id}{Released Performance Metric (PPM) identifiers.}
\item{pgp_id}{Released PGS Catalog Publication (PGP) identifiers.}
\item{notes}{News about the release.}
}
}
\description{
This function retrieves PGS Catalog release information. Note that the
columns \code{pgs_id}, \code{ppm_id} and \code{pgp_id} contain in each
element a vector. These columns can be unnested using
\code{\link[tidyr]{unnest_longer}} (see Examples).
}
\examples{
\dontrun{
# Get the latest release
get_releases()
get_releases(date = 'latest')

# Get all releases
get_releases(date = 'all')

# Get a specific release by date
get_releases(date = '2020-08-19')
}

}
