% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame_br.R
\name{frame_br}
\alias{frame_br}
\title{Visualization of quantile regression model fitting: br algorithem}
\usage{
frame_br(object, tau)
}
\arguments{
\item{object}{quantile regression model using br method}

\item{tau}{quantiles can be a single quantile or a vector of
quantiles}
}
\value{
All observations and the observations used in quantile
regression fitting using br algorithem
}
\description{
get the observation used in br algorithem
}
\details{
This is a function that can be used to create point plot
for the observations used in quantile regression fitting based
on 'br'method.
}
\examples{
library(ggplot2)
library(quantreg)
data(ais)
tau <- c(0.1, 0.5, 0.9)
object1 <- rq(BMI ~ LBM, tau, method = 'br', data = ais)
data_plot <- frame_br(object1, tau)$all_observation
choose <- frame_br(object1, tau)$fitting_point
ggplot(data_plot,
 aes(x=value, y=data_plot[,2])) +
 geom_point(alpha = 0.1) +
 ylab('y') +
 xlab('x') +
 facet_wrap(~variable, scales = "free_x", ncol = 2) +
 geom_point(data = choose, aes(x = x, y = y,
                                      group = tau_flag,
                                      colour = tau_flag,
                                      shape = obs))

object2 <- rq(BMI ~ Ht + LBM + Wt, tau, method = 'br',
            data = ais)
data_plot <- frame_br(object2, tau)$all_observation
choose <- frame_br(object2, tau)$fitting_point
ggplot(data_plot,
 aes(x=value, y=data_plot[,2])) +
 geom_point(alpha = 0.1) +
 ylab('y') +
 xlab('x') +
 facet_wrap(~variable, scales = "free_x", ncol = 2) +
 geom_point(data = choose, aes(x = x, y = y,
                                      group = tau_flag,
                                      colour = tau_flag,
                                      shape = obs))
}
\author{
Wenjing Wang \email{wenjingwangr@gmail.com}
}
