# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title logit and inverse logit functions
#'
#' @description
#' transform \code{x} either via the logit, or inverse logit.
#'
#' @details
#' The logit and inverse logit functions are part of R via the
#' logistic distribution functions in the stats package.
#' Quoting from the documentation for the logistic distribution
#'
#' "\code{qlogis(p)} is the same as the \code{logit} function, \code{logit(p) =
#' log(p/1-p)}, and \code{plogis(x)} has consequently been called the 'inverse
#' logit'."
#'
#' See the examples for benchmarking these functions.  The \code{logit} and
#' \code{invlogit} functions are faster than the \code{qlogis} and \code{plogis}
#' functions.
#'
#' @seealso \code{\link[stats:Logistic]{qlogis}}
#'
#' @examples
#' library(rbenchmark)
#'
#' # compare logit to qlogis
#' p <- runif(1e5)
#' identical(logit(p), qlogis(p))
#'
#' \dontrun{
#' rbenchmark::benchmark(logit(p), qlogis(p))
#' }
#'
#' # compare invlogit to plogis
#' x <- runif(1e5, -1000, 1000)
#' identical(invlogit(x), plogis(x))
#'
#' \dontrun{
#' rbenchmark::benchmark(invlogit(x), plogis(x))
#' }
#'
#' @param x a numeric vector
#' @export
#' @rdname logit
logit <- function(x) {
    .Call('_qwraps2_logit', PACKAGE = 'qwraps2', x)
}

#' @export
#' @rdname logit
invlogit <- function(x) {
    .Call('_qwraps2_invlogit', PACKAGE = 'qwraps2', x)
}

#' @title Trapezoid Rule Numeric Integration
#'
#' @description Compute the integral of y with respect to x via trapezoid rule.
#'
#' @param x,y numeric vectors of equal length
#'
#' @return a numeric value, the estimated integral
#'
#' @examples
#' xvec <- seq(-2 * pi, 3 * pi, length = 560)
#' foo  <- function(x) { sin(x) + x * cos(x) + 12 }
#' yvec <- foo(xvec)
#' plot(xvec, yvec, type = "l")
#'
#' integrate(f = foo, lower = -2 * pi, upper = 3 * pi)
#' traprule(xvec, yvec)
#'
#' @export
traprule <- function(x, y) {
    .Call('_qwraps2_traprule', PACKAGE = 'qwraps2', x, y)
}

