% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_PQL_Function.R
\name{glmPQL}
\alias{glmPQL}
\title{Compute PQL estimates for fixed effects from a generalized linear model.}
\usage{
glmPQL(glm.mod, niter = 20, data = NULL)
}
\arguments{
\item{glm.mod}{a generalized linear model fitted with the glm function.}

\item{niter}{maximum number of iterations allowed in the PQL algorithm.}

\item{data}{The data used by the fitted model. This argument is required
for models with special expressions in their formula, such as
offset, log, cbind(sucesses, trials), etc.}
}
\value{
A glmPQL object (i.e. a linear model using pseudo outcomes).
}
\description{
Compute PQL estimates for fixed effects from a generalized linear model.
}
\examples{

# Load the datasets package for example code
library(datasets)
library(dplyr)

# We'll model the number of world changing discoveries per year for the
# last 100 years as a poisson outcome. First, we set up the data

dat = data.frame(discoveries) \%>\% mutate(year = 1:length(discoveries))

# Fit the GLM with a poisson link function
mod <- glm(discoveries~year+I(year^2), family = 'poisson', data = dat)

# Find PQL estimates using the original GLM
mod.pql = glmPQL(mod)

# Note that the PQL model yields a higher R Squared statistic
# than the fit of a strictly linear model. This is attributed
# to correctly modelling the distribution of outcomes and then
# linearizing the model to measure goodness of fit, rather than
# simply fitting a linear model

summary(mod.pql)
summary(linfit <- lm(discoveries~year+I(year^2), data = dat))

r2beta(mod.pql)
r2beta(linfit)

}
