% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kruskalTest.R
\name{kruskalTest}
\alias{kruskalTest}
\alias{print.kruskalTestSPSS}
\title{Kruskal-Wallis Test}
\usage{
kruskalTest(data, variable, group)

\method{print}{kruskalTestSPSS}(x, digits = 2:3, statistics = c("ranks", "test"), ...)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variable}{a character string specifying the numeric variable of
interest.}

\item{group}{a character string specifying a grouping variable.}

\item{x}{an object of class \code{"kruskalTestSPSS"} as returned by
function \code{kruskalTest}.}

\item{digits}{an integer vector giving the number of digits after the comma
to be printed in the LaTeX tables.  The first element corresponds to the
number of digits in table with the summary of the ranks, and the second
element corresponds to the number of digits in the table for the test.}

\item{statistics}{a character vector specifying which LaTeX tables should
be printed.  Available options are \code{"ranks"} for a summary of the ranks
and \code{"test"} for test results.  The default is to print both tables.}

\item{\dots}{currently ignored.}
}
\value{
An object of class \code{"kruskalTestSPSS"} with the following components:
\describe{
  \item{\code{statistics}}{a data frame containing information on the
  per-group mean ranks.}
  \item{\code{test}}{a list containing the results of the Kruskal-Wallis
  test.}
  \item{\code{variable}}{a character string containing the name of the
  numeric variable of interest.}
  \item{\code{group}}{a character string containing the name of the
  grouping variable.}
}

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output (version <24).
}
\description{
Perform a Kruskal-Wallis test on variables of a data set.  The output is
printed as a LaTeX table that mimics the look of SPSS output (version <24).
}
\examples{
# load data
data("Eredivisie")

# test whether market values differ by playing position
kruskalTest(Eredivisie, "MarketValue", group = "Position")

}
\author{
Andreas Alfons
}
\keyword{htest}
