% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signTest.R
\name{signTest}
\alias{signTest}
\alias{print.signTestSPSS}
\title{Sign Test}
\usage{
signTest(data, variables, exact = FALSE)

\method{print}{signTestSPSS}(x, digits = 3, statistics = c("frequencies", "test"), ...)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variables}{a character vector specifying two numeric variables
containing the paired observations.}

\item{exact}{a logical indicating whether or not to include the exact
p-value using the binomial distribution.  Note that the p-value using the
normal approximation is always reported.}

\item{x}{an object of class \code{"signTestSPSS"} as returned by function
\code{signTest}.}

\item{digits}{an integer giving the number of digits after the comma to be
printed in the LaTeX tables.}

\item{statistics}{a character vector specifying which LaTeX tables should
be printed.  Available options are \code{"frequencies"} for a summary of the
frequencies and \code{"test"} for test results.  The default is to print
both tables.}

\item{\dots}{currently ignored.}
}
\value{
An object of class \code{"signTestSPSS"} with the following
components:
\describe{
  \item{\code{statistics}}{a data frame containing information on the
  number of observations with negative and positive differences.}
  \item{\code{asymptotic}}{a list containing the results of the test using
  the normal approximation.}
  \item{\code{exact}}{if requested, a numeric vector containing the exact
  two-sided p-value, one-sided p-value, and point probability using the
  binomial distribution.}
  \item{\code{variables}}{a character vector containing the names of the two
  numeric variables with the paired observations.}
  \item{\code{n}}{an integer giving the number of observations.}
}

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output (version <24).
}
\description{
Perform a sign test for a paired sample on variables of a data set.  The
output is printed as a LaTeX table that mimics the look of SPSS output
(version <24).
}
\examples{
# load data
data("Exams")

# test whether grades differ between the
# regular exam and the resit
signTest(Exams, c("Regular", "Resit"))

}
\author{
Andreas Alfons
}
\keyword{htest}
