% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_thinning.R
\name{prepare_thinning}
\alias{prepare_thinning}
\title{Check and prepare management information.}
\usage{
prepare_thinning(thinning = NULL, sp_names = c("Fagus sylvatica",
  "Pinus sylvestris"))
}
\arguments{
\item{thinning}{table containing the information about thinnings. If there is no thinning, it must be \code{NULL}. The following columns are required:
\itemize{
\item species: species or cohort id/name.
\item age: age at which thinning is done.
\item stems_n: number of trees remaining after thinning
\item stem: type of thinning (above/below). Default is 1.
\item foliage: type of thinning (above/below). Default is 1.
\item root: type of thinning (above/below). Default is 1.
}}

\item{sp_names}{names of the species / cohorts used for the simulations. This is required whether `thinning=NULL` or if not all species are indicated in the `thinning` table. The `sp_names` must be identical to those from \code{species} table.}
}
\value{
a 3-dimentional array, where third dimention correspond to each species.
}
\description{
Prepares the management table and checks for consistency.
}
\details{
This function prepares the thinning table for \code{\link{run_3PG}}.

In case there is no thinning it will return empty 3-d array.

In case there will be thinning it will return 3-d array, where one dimension correspond to each species.
}
\examples{
prepare_thinning( thinning = NULL, sp_names = c('Quercus', 'Abies'))

prepare_thinning( thinning = d_thinning, sp_names = c('Fagus sylvatica', 'Pinus sylvestris'))
}
\seealso{
\code{\link{run_3PG}}, \code{\link{prepare_input}}, \code{\link{prepare_parameters}}, \code{\link{prepare_sizeDist}}, \code{\link{prepare_climate}}
}
