% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSMethod.TA1.8.R
\name{SSMethod.TA1.8}
\alias{SSMethod.TA1.8}
\title{Apply Francis composition weighting method TA1.8}
\usage{
SSMethod.TA1.8(fit, type, fleet, part = 0:2, sexes = 0:3,
  seas = NULL, method = NULL, plotit = TRUE, printit = TRUE,
  datonly = FALSE, plotadj = !datonly, maxpanel = 1000,
  fleetnames = NULL, label.part = TRUE, label.sex = TRUE,
  set.pars = TRUE)
}
\arguments{
\item{fit}{Stock Synthesis output as read by r4SS function SS_output}

\item{type}{either 'len' (for length composition data), 'size' (for
generalized size composition data), 'age' (for age composition data),
or 'con' (for conditional age at length data)}

\item{fleet}{vector of one or more fleet numbers whose data are to
be analysed simultaneously (the output N multiplier applies
to all fleets combined)}

\item{part}{vector of one or more partition values; analysis is restricted
to composition data with one of these partition values.
Default is to include all partition values (0, 1, 2).}

\item{sexes}{vector of one or more values for Sexes; analysis is
restricted to composition data with one of these
Sexes values.  Ignored if type=='con'.}

\item{seas}{string indicating how to treat data from multiple seasons
'comb' - combine seasonal data for each year and plot against Yr
'sep' - treat seasons separately, plotting against Yr.S
If is.null(seas) it is assumed that there is only one season in
the selected data (a warning is output if this is not true) and
option 'comb' is used.}

\item{method}{a vector of one or more size-frequency method numbers
(ignored unless type = 'size').
If !is.null(method), analysis is restricted to size-frequency
methods in this vector.  NB comps are separated by method}

\item{plotit}{if TRUE, make an illustrative plot like one or more
panels of Fig. 4 in Francis (2011).}

\item{printit}{if TRUE, print results to R console.}

\item{datonly}{if TRUE, don't show the model expectations}

\item{plotadj}{if TRUE, plot the confidence intervals associated with
the adjusted sample sizes (TRUE by default unless datonly = TRUE)}

\item{maxpanel}{maximum number of panels within a plot}

\item{fleetnames}{Vector of alternative fleet names to draw from for
plot titles and captions. It should have length equal to the number
of fleets in the model, not the number of fleets considered in this function.}

\item{label.part}{Include labels indicating which partitions are included?}

\item{label.sex}{Include labels indicating which sexes are included?}

\item{set.pars}{Set the graphical parameters such as mar and mfrow.
Can be set to FALSE in order to add plots form multiple calls to
this function as separate panels in one larger figure.}
}
\description{
Uses method TA1.8 (described in Appendix A of Francis 2011) to do
stage-2 weighting of composition data from a Stock Synthesis model.
Outputs a multiplier, \emph{w} (with bootstrap 95\% confidence interval),
so that \emph{N2y} = \emph{w} x \emph{N1y}, where \emph{N1y} and
\emph{N2y} are the stage-1 and stage-2
multinomial sample sizes for the data set in year y.  Optionally
makes a plot of observed (with confidence limits, based on \emph{N1y})
and expected mean lengths (or ages).
\cr\cr
CAUTIONARY/EXPLANATORY NOTE.
The large number of options available in SS makes it very
difficult to be sure that what this function does is
appropriate for all combinations of options.  The following
notes might help anyone wanting to check or correct the code.
\enumerate{
  \item The code first takes the appropriate database (lendbase, sizedbase,
        agedbase, or condbase) and removes un-needed rows.
  \item The remaining rows of the database are grouped into individual
        comps (indexed by vector indx) and relevant statistics (e.g.,
        observed and expected mean length or age), and ancillary data,
        are calculated for each comp (these are stored in pldat - one row
        per comp).
        If the data are to be plotted, the comps are grouped, with each
        group corresponding to a panel in the plot, and groups are indexed
        by plindx.
  \item A single multiplier is calculated to apply to all the comps.
}
}
\examples{
\dontrun{
Nfleet <- length(myreplist$FleetNames)
for (Ifleet in 1:Nfleet)
  SSMethod.TA1.8(myreplist,"len",fleet=Ifleet,maxpanel=maxpanel)
for (Ifleet in 1:Nfleet)
  SSMethod.TA1.8(myreplist,"age",fleet=Ifleet,maxpanel=maxpanel)
for (Ifleet in 1:Nfleet)
  SSMethod.TA1.8(myreplist,"size",fleet=Ifleet,maxpanel=maxpanel)
for (Ifleet in 1:Nfleet)
  SSMethod.TA1.8(myreplist,"con",fleet=Ifleet,maxpanel=maxpanel)
for (Ifleet in 1:Nfleet)
  SSMethod.Cond.TA1.8(myreplist,fleet=Ifleet,maxpanel=maxpanel)
}

}
\references{
Francis, R.I.C.C. (2011). Data weighting in statistical
fisheries stock assessment models. Canadian Journal of
Fisheries and Aquatic Sciences 68: 1124-1138.
}
\seealso{
\code{\link{SSMethod.Cond.TA1.8}}
}
\author{
Chris Francis, Andre Punt, Ian Taylor
}
