% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotComparisons.R
\name{SSplotComparisons}
\alias{SSplotComparisons}
\title{plot model comparisons}
\usage{
SSplotComparisons(summaryoutput, subplots = 1:20, plot = TRUE,
  print = FALSE, png = print, pdf = FALSE, models = "all",
  endyrvec = "default", indexfleets = NULL, indexUncertainty = FALSE,
  indexQlabel = TRUE, indexQdigits = 4, indexSEvec = "default",
  indexPlotEach = FALSE, labels = c("Year", "Spawning biomass (t)",
  "Fraction of unfished", "Age-0 recruits (1,000s)",
  "Recruitment deviations", "Index", "Log index", "1 - SPR", "Density",
  "Management target", "Minimum stock size threshold", "Spawning output",
  "Harvest rate"), col = NULL, shadecol = NULL, pch = NULL,
  lty = 1, lwd = 2, spacepoints = 10, staggerpoints = 1,
  initpoint = 0, tickEndYr = TRUE, shadeForecast = TRUE,
  xlim = "default", ylimAdj = 1.05, xaxs = "i", yaxs = "i",
  type = "o", uncertainty = TRUE, shadealpha = 0.1, legend = TRUE,
  legendlabels = "default", legendloc = "topright",
  legendorder = "default", legendncol = 1, sprtarg = NULL,
  btarg = NULL, minbthresh = NULL, pwidth = 6.5, pheight = 5,
  punits = "in", res = 300, ptsize = 10, cex.main = 1,
  plotdir = NULL, filenameprefix = "", densitynames = c("SSB_Virgin",
  "R0"), densityxlabs = "default", rescale = TRUE, densityscalex = 1,
  densityscaley = 1, densityadjust = 1, densitysymbols = TRUE,
  densitytails = TRUE, densitymiddle = FALSE, densitylwd = 1,
  fix0 = TRUE, new = TRUE, add = FALSE, par = list(mar = c(5, 4, 1,
  1) + 0.1), verbose = TRUE, mcmcVec = FALSE,
  show_equilibrium = TRUE)
}
\arguments{
\item{summaryoutput}{List created by \code{SSsummarize}}

\item{subplots}{Vector of subplots to be created
Numbering of subplots is as follows:
\itemize{
  \item 1  spawning biomass
  \item 2  spawning biomass with uncertainty intervals
  \item 3  biomass ratio (hopefully equal to fraction of unfished)
  \item 4  biomass ratio with uncertainty
  \item 5  SPR ratio
  \item 6  SPR ratio with uncertainty
  \item 7  F value
  \item 8  F value with uncertainty
  \item 9  recruits
  \item 10  recruits with uncertainty
  \item 11  recruit devs
  \item 12  recruit devs with uncertainty
  \item 13  index fits
  \item 14  index fits on a log scale
  \item 15  phase plot
  \item 16  densities
  \item 17  cumulative densities
}
Note that this represents a revision in the numbering for 7 and higher
from the numbering used up to r4ss version 1.36.0 which was as follows:
\itemize{
  \item 18  F value with uncertainty
  \item 7  recruits
  \item 8  recruits with uncertainty
  \item 9  recruit devs
  \item 10  recruit devs with uncertainty
  \item 11  index fits
  \item 12  index fits on a log scale
  \item 13  phase plot
  \item 14  densities
  \item 15  cumulative densities
}}

\item{plot}{Plot to active plot device?}

\item{print}{Send plots to PNG files in directory specified by
\code{plotdir}?}

\item{png}{Has same result as \code{print}, included for consistency with
\code{SS_plots}.}

\item{pdf}{Write output to PDF file? Can't be used in conjunction with
\code{png} or \code{print}.}

\item{models}{Optional subset of the models described in
\code{summaryoutput}.  Either "all" or a vector of numbers indicating
columns in summary tables.}

\item{endyrvec}{Optional single year or vector of years representing the
final year of values to show for each model. By default it is set to the
ending year specified in each model.}

\item{indexfleets}{Vector of fleet numbers for each model for which to compare
indices of abundance. Only necessary if any model has more than one index.}

\item{indexUncertainty}{Show uncertainty intervals on index data?
Default=FALSE because if models have any extra standard deviations added,
these intervals may differ across models.}

\item{indexQlabel}{Add catchability to legend in plot of index fits
(TRUE/FALSE)?}

\item{indexQdigits}{Number of significant digits for catchability in legend
(if \code{indexQlabel=TRUE})}

\item{indexSEvec}{Optional replacement for the SE values in
summaryoutput$indices to deal with the issue of differing uncertainty by
models described above.}

\item{indexPlotEach}{TRUE plots the observed index for each model with
colors, or FALSE just plots observed once in black dots.}

\item{labels}{Vector of labels for plots (titles and axis labels)}

\item{col}{Optional vector of colors to be used for lines. Input NULL
makes use of \code{rich.colors.short} function.}

\item{shadecol}{Optional vector of colors to be used for shading uncertainty
intervals. Input NULL makes use of \code{rich.colors.short} function
with alpha transparency.}

\item{pch}{Optional vector of plot character values}

\item{lty}{Optional vector of line types}

\item{lwd}{Optional vector of line widths}

\item{spacepoints}{Number of years between points shown on top of lines (for
long timeseries, points every year get mashed together)}

\item{staggerpoints}{Number of years to stagger the first point (if
\code{spacepoints > 1}) for each line (so that adjacent lines have points in
different years)}

\item{initpoint}{Year value for first point to be added to lines.
Points added to plots are those that satisfy
(Yr-initpoint)\%\%spacepoints == (staggerpoints*iline)\%\%spacepoints}

\item{tickEndYr}{TRUE/FALSE switch to turn on/off extra axis mark at final
year in timeseries plots.}

\item{shadeForecast}{TRUE/FALSE switch to turn on off shading of years beyond
the maximum ending year of the models}

\item{xlim}{Optional x limits}

\item{ylimAdj}{Multiplier for ylim parameter. Allows additional white space
to fit legend if necessary. Default=1.05.}

\item{xaxs}{Choice of xaxs parameter (see ?par for more info)}

\item{yaxs}{Choice of yaxs parameter (see ?par for more info)}

\item{type}{Type parameter passed to points (default 'o' overplots points on
top of lines)}

\item{uncertainty}{Show plots with uncertainty intervals? Either a single
TRUE/FALSE value, or a vector of TRUE/FALSE values for each model,
or a set of integers corresponding to the choice of models.}

\item{shadealpha}{Transparency adjustment used to make default shadecol
values (implemented as \code{adjustcolor(col=col, alpha.f=shadealpha)})}

\item{legend}{Add a legend?}

\item{legendlabels}{Optional vector of labels to include in legend. Default
is 'model1','model2',etc.}

\item{legendloc}{Location of legend. Either a string like "topleft" or a vector
of two numeric values representing the fraction of the maximum in the x and y
dimensions, respectively. See ?legend for more info on the string options.}

\item{legendorder}{Optional vector of model numbers that can be used to have
the legend display the model names in an order that is different than that
which is represented in the summary input object.}

\item{legendncol}{Number of columns for the legend.}

\item{sprtarg}{Target value for SPR-ratio where line is drawn in the SPR
plots and phase plot.}

\item{btarg}{Target biomass value at which to show a line (set to 0 to
remove)}

\item{minbthresh}{Minimum biomass threshold at which to show a line (set to
0 to remove)}

\item{pwidth}{Width of plot}

\item{pheight}{Height of plot}

\item{punits}{Units for PNG file}

\item{res}{Resolution for PNG file}

\item{ptsize}{Point size for PNG file}

\item{cex.main}{Character expansion for plot titles}

\item{plotdir}{Directory where PNG or PDF files will be written. By default
it will be the directory where the model was run.}

\item{filenameprefix}{Additional text to append to PNG or PDF file names.
It will be separated from default name by an underscore.}

\item{densitynames}{Vector of names (or subset of names) of parameters or
derived quantities contained in summaryoutput$pars$Label or
summaryoutput$quants$Label for which to make density plots}

\item{densityxlabs}{Optional vector of x-axis labels to use in the density
plots (must be equal in length to the printed vector of quantities that
match the \code{densitynames} input)}

\item{rescale}{TRUE/FALSE control of automatic rescaling of units into
thousands, millions, or billions}

\item{densityscalex}{Scalar for upper x-limit in density plots (values below
1 will cut off the right tail to provide better contrast among narrower
distributions}

\item{densityscaley}{Scalar for upper y-limit in density plots (values below
1 will cut off top of highest peaks to provide better contrast among broader
distributions}

\item{densityadjust}{Multiplier on bandwidth of kernel in density function
used for smoothing MCMC posteriors. See 'adjust' in ?density for details.}

\item{densitysymbols}{Add symbols along lines in density plots. Quantiles
are \code{c(0.025,0.1,0.25,0.5,0.75,0.9,0.975)}.}

\item{densitytails}{Shade tails outside of 95\% interval darker in density plots?}

\item{densitymiddle}{Shade middle inside of 95\% interval darker in density plots?}

\item{densitylwd}{Line width for density plots}

\item{fix0}{Always include 0 in the density plots?}

\item{new}{Create new empty plot window}

\item{add}{Allows single plot to be added to existing figure. This needs to
be combined with specific 'subplots' input to make sure only one thing gets
added.}

\item{par}{list of graphics parameter values passed to the \code{par}
function}

\item{verbose}{Report progress to R GUI?}

\item{mcmcVec}{Vector of TRUE/FALSE values (or single value) indicating
whether input values are from MCMC or to use normal distribution around
MLE}

\item{show_equilibrium}{Whether to show the equilibrium values for
SSB. For some model comparisons, these might not be comparable and thus
useful to turn off. Defaults to TRUE.}
}
\description{
Creates a user-chosen set of plots comparing model output from a summary of
multiple models, where the collection was created using the
\code{SSsummarize} function.
}
\examples{

  \dontrun{
# directories where models were run need to be defined
dir1 <- 'c:/SS/mod1'
dir2 <- 'c:/SS/mod2'

# read two models
mod1 <- SS_output(dir=dir1)
mod2 <- SS_output(dir=dir2)

# create list summarizing model results
mod.sum <- SSsummarize(list(mod1, mod2))

# plot comparisons
SSplotComparisons(mod.sum, legendlabels=c("First model", "Second model"))

# Example showing comparison of MLE to MCMC results where the mcmc would have
# been run in the subdirectory 'c:/SS/mod1/mcmc'
mod1 <- SS_output(dir='c:/SS/mod1', dir.mcmc='mcmc')
# pass the same model twice to SSsummarize in order to plot it twice 
mod.sum <- SSsummarize(list(mod1, mod1))
# compare MLE to MCMC
SSplotComparisons(mod.sum, legendlabels=c("MCMC", "MLE"), mcmcVec=c(TRUE,FALSE))

}
}
\seealso{
\code{\link{SS_plots}}, \code{\link{SSsummarize}},
\code{\link{SS_output}}, \code{\link{SSgetoutput}}
}
\author{
Ian G. Taylor, John R. Wallace
}
