% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{pipeline}
\alias{pipeline}
\title{Pipeline used for running a model start to finish.}
\usage{
pipeline(data, formula, parameters, columns, stan = FALSE, seed = 42)
}
\arguments{
\item{data}{data.frame The input data}

\item{formula}{character The formula for the multivariate model}

\item{parameters}{vector The validity coefficients}

\item{columns}{vector The columns of the covariates}

\item{stan}{bool If you would like to run with the Stan backend}

\item{seed}{numeric The random seed to use}
}
\value{
list The output parameters
}
\description{
This is an unexported function that can run the entire
pre-model, attenuation-contamination matrix, and model
fitting from start to finish.
}
\examples{
data <- data.frame(
 list(
   "BMI" = rnorm(100, mean = 0, sd = 1),
   "fruit" = rnorm(100, mean = 0, sd = 1),
   "veg" = rnorm(100, mean = 0, sd = 1),
   "tobacco" = rnorm(100, mean = 0, sd = 1)
 )
)
parameters <- list(
  fruit = c(0.3, 0.55, 0.8),
  veg = c(0.25, 0.5, 0.75),
  tobacco = c(0.4, 0.55, 0.7)
)
grid <- expand.grid(parameters)
param_grid <- list()
for (i in seq_len(nrow(grid))) {
  name <- paste0("iteration_", i)
  param_grid[[name]] <- list(
    parameters = grid[i, ]
  )
}
output <- pipeline(
   data,
   "BMI ~ fruit + veg + tobacco",
   as.numeric(param_grid[[i]][["parameters"]]),
   c("fruit", "veg", "tobacco")
)

}
