% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amPlot.R
\name{amPlot}
\alias{amPlot}
\alias{amPlot.default}
\alias{amPlot.numeric}
\alias{amPlot.character}
\alias{amPlot.factor}
\alias{amPlot.data.frame}
\alias{amPlot.formula}
\title{Plot serial data}
\usage{
amPlot(x, ...)

\method{amPlot}{default}(x, ...)

\method{amPlot}{numeric}(x, y, bullet = c("round", "diamond", "square",
  "bubble", "yError", "xError", "triangleLeft", "triangleRight", "triangleUp",
  "triangleDown"), type = c("points", "line", "smoothedLine", "step", "both"),
  col = "#0066cc", fill_alphas = 0, weights = NULL, precision = 2, id,
  error, xlab, ylab, lty, cex, lwd, xlim, ylim, ...)

\method{amPlot}{character}(x, y, bullet = c("round", "diamond", "square",
  "bubble", "yError", "xError", "triangleLeft", "triangleRight", "triangleUp",
  "triangleDown"), type = c("points", "line", "smoothedLine", "step", "both"),
  col = "#0066cc", fill_alphas = 0, weights = NULL, precision = 2,
  parseDates = FALSE, dataDateFormat, id, error, xlab, ylab, lty, cex, lwd,
  xlim, ylim, ...)

\method{amPlot}{factor}(x, y, bullet = "round", type = "p", col = "gray",
  weights = NULL, precision = 2, parseDates = FALSE,
  dataDateFormat = NULL, id, error, xlab, ylab, lty, cex, lwd, xlim, ylim,
  ...)

\method{amPlot}{data.frame}(x, columns, type = "l", precision = 2, xlab,
  ylab, fill_alphas = 0, ...)

\method{amPlot}{formula}(x, data, type = "p", fill_alphas = 0, xlab, ylab,
  main = "", ...)
}
\arguments{
\item{x}{the coordinates of points in the plot : \code{numeric},
\code{data.frame}, or \code{formula}.}

\item{...}{see \code{\link{amOptions}} for more options.}

\item{y}{\code{numeric}, the y coordinates of points in the plot,
optional if x is an appropriate structure.}

\item{bullet}{\code{character}, point shape. Possible values are : "diamond", "square", 
"bubble",  "yError", "xError", "round", "triangleLeft", "triangleRight", "triangleUp", 
"triangleDown". Default set to "round".}

\item{type}{\code{character}, type of plot. Possible values are : "l" for a line, "sl" 
for a smoothed line (deprecated), "st" for steps, "p" for points, and "b" for line and points.
Default set to "p".}

\item{col}{either a \code{factor} or a \code{character}, default set to "gray".}

\item{fill_alphas}{a \code{numeric} between 0 and 1 for printed area.}

\item{weights}{\code{numeric}, weights for x/y charts only. Small values are prefered for lisibility.}

\item{precision}{\code{numeric}, precision you wish to display. Default set to 2.}

\item{id}{\code{numeric}, point id, for x/y charts only. Default 1:length(x).}

\item{error}{\code{numeric}, only when type is "xError" "yError" default NULL,}

\item{xlab}{\code{character},  label for x-axis.}

\item{ylab}{\code{character},  label for y-axis.}

\item{lty}{\code{numeric}, line type (dashes).}

\item{cex}{\code{numeric}, bullet size.}

\item{lwd}{\code{numeric}, line width}

\item{xlim}{\code{numeric}, x range.}

\item{ylim}{\code{numeric}, y range.}

\item{parseDates}{\code{logical}, default set to FALSE, if TRUE argument 
\code{dataDateFormat} has to be provided.}

\item{dataDateFormat}{\code{character}, default set to NULL. Even if your chart parses dates,
you can pass them as strings in your dataframe - 
all you need to do is to set data date format and the chart will parse dates to date objects.
Check this page for available formats.
Please note that two-digit years (YY) as well as literal month names (MMM)  are NOT supported in this setting.}

\item{columns}{(optional) either a vector of \code{character} containing
the names of the series to draw, or a \code{numeric} vector of indices.
By default all numeric columns will be drawn.}

\item{data}{dataset}

\item{main}{title}
}
\value{
Return an Amchart.
}
\description{
amPlot computes a plot of the given data values (can be a vector,  dataframe or formula).
}
\examples{

\dontrun{
# 'numeric':
amPlot(x = rnorm(100))

# add line
 amPlot(x = rnorm(100), type = 'sl', legend = T) \%>>\%
    amLines(x = rnorm(100), type = "p")
    
# 'character':
start <- as.POSIXct('01-01-2015', format = '\%d-\%m-\%Y')
end <- as.POSIXct('31-12-2015', format = '\%d-\%m-\%Y')
date <- seq.POSIXt(from = start, to = end, by = 'day')
date <- format(date, '\%m-\%d-\%Y')

y <- rnorm(length(date))
amPlot(x = date, y = y, type = 'l', parseDates = TRUE, dataDateFormat = "MM-DD-YYYY")
# notice that by default 'parseDates = FALSE'

# 'data.frame'
amPlot(iris, col = colnames(iris)[1:2], type = c("l", "st"), zoom = TRUE, legend = TRUE)

# 'formula':
amPlot(Petal.Length + Sepal.Length ~ Sepal.Width, data = iris, legend = TRUE, zoom = TRUE)
}

\donttest{
# Other examples available which can be time consuming depending on your configuration.
library(data.table)

iris <- as.data.table(get("iris", "package:datasets"))
x <- rnorm(100)

# Simple scatter plot with title and color
# Also change type (set to "p" by default), avalaible "l", "sl", "st", "p", "b"
amPlot(x = x, main = "Title", col = "lightblue", type = "b")

x <- sort(rnorm(100))
y <- runif(100)
weights <- runif(100, 0, 15)
amPlot(x = x, y = y, weights = weights)
}
}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
