% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amRangeAreaChart.R
\name{amRangeAreaChart}
\alias{amRangeAreaChart}
\title{HTML widget displaying a range area chart}
\usage{
amRangeAreaChart(
  data,
  data2 = NULL,
  xValue,
  yValues,
  areas = NULL,
  xLimits = NULL,
  yLimits = NULL,
  expandX = 0,
  expandY = 5,
  Xformatter = ifelse(isDate, "yyyy-MM-dd", "#."),
  Yformatter = "#.",
  chartTitle = NULL,
  theme = NULL,
  draggable = FALSE,
  tooltip = NULL,
  bullets = NULL,
  alwaysShowBullets = FALSE,
  lineStyle = NULL,
  backgroundColor = NULL,
  xAxis = NULL,
  yAxis = NULL,
  scrollbarX = FALSE,
  scrollbarY = FALSE,
  legend = NULL,
  caption = NULL,
  image = NULL,
  button = NULL,
  cursor = FALSE,
  width = NULL,
  height = NULL,
  export = FALSE,
  chartId = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{a dataframe}

\item{data2}{\code{NULL} or a dataframe used to update the data with the
button; its column names must include the column names of \code{data}
given in \code{yValues}, it must have the same number of rows as
\code{data} and its rows must be in the same order as those of \code{data}}

\item{xValue}{name of the column of \code{data} to be used on the x-axis}

\item{yValues}{a character matrix with two columns; each row corresponds to
a range area and provides the names of two columns of \code{data} to be
used as the limits of the range area}

\item{areas}{an unnamed list of list of settings for the range areas; the
n-th inner list of settings corresponds to the n-th row of the
\code{yValues} matrix; each list of settings has three possible fields:
\code{name} for the legend label, \code{color} for the color of the range
area, and \code{opacity} for the opacity of the range area, a number
between 0 and 1}

\item{xLimits}{range of the x-axis, a vector of two values specifying
the left and right limits of the x-axis; \code{NULL} for default values}

\item{yLimits}{range of the y-axis, a vector of two values specifying
the lower and upper limits of the y-axis; \code{NULL} for default values}

\item{expandX}{if \code{xLimits = NULL}, a percentage of the range of the
x-axis used to expand this range}

\item{expandY}{if \code{yLimits = NULL}, a percentage of the range of the
y-axis used to expand this range}

\item{Xformatter}{a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-numbers/}{number formatting string}
if \code{xValue} is set to a numeric column of \code{data};
it is used to format the values displayed in the cursor tooltips if
\code{cursor = TRUE}, the labels of the x-axis unless you specify
your own formatter in the \code{labels} field of the list passed on to
the \code{xAxis} option, and the values displayed in the tooltips unless
you specify your own tooltip text;
if \code{xValue} is set to a date column of \code{data}, this option should
be set to a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-date-time/}{date formatting string},
and it has an effect only on the values displayed in the tooltips (unless
you specify your own tooltip text); formatting the dates on the x-axis is
done via the \code{labels} field of the list passed on to the \code{xAxis}
option}

\item{Yformatter}{a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-numbers/}{number formatting string};
it is used to format the values displayed in the cursor tooltips if
\code{cursor = TRUE}, the labels of the y-axis unless you specify
your own formatter in the \code{labels} field of the list passed on to
the \code{yAxis} option, and the values displayed in the tooltips unless
you specify your own tooltip text (see the first example of
\code{\link{amBarChart}} for the way to set
a number formatter in the tooltip text)}

\item{chartTitle}{chart title, it can be \code{NULL} or \code{FALSE} for no
title, a character string,
a list of settings created with \code{\link{amText}}, or a list with two
fields: \code{text}, a list of settings created with \code{\link{amText}},
and \code{align}, can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{theme}{theme, \code{NULL} or one of \code{"dataviz"},
\code{"material"}, \code{"kelly"}, \code{"dark"}, \code{"moonrisekingdom"},
\code{"frozen"}, \code{"spiritedaway"}, \code{"patterns"},
\code{"microchart"}}

\item{draggable}{\code{TRUE}/\code{FALSE} to enable/disable dragging of
all lines, otherwise a named list of the form
\code{list(yvalue1 = TRUE, yvalue2 = FALSE, ...)} to enable/disable the
dragging for each series corresponding to a column given in \code{yValues}}

\item{tooltip}{settings of the tooltips; \code{NULL} for default,
\code{FALSE} for no tooltip, otherwise a named list of the form
\code{list(yvalue1 = settings1, yvalue2 = settings2, ...)} where
\code{settings1}, \code{settings2}, ... are lists created with
\code{\link{amTooltip}}; this can also be a
single list of settings that will be applied to each series,
or a just a string for the text to display in the tooltip}

\item{bullets}{settings of the bullets; \code{NULL} for default,
otherwise a named list of the form
\code{list(yvalue1 = settings1, yvalue2 = settings2, ...)} where
\code{settings1}, \code{settings2}, ... are lists created with
\code{\link{amCircle}}, \code{\link{amTriangle}} or
\code{\link{amRectangle}}; this can also be a
single list of settings that will be applied to each series}

\item{alwaysShowBullets}{logical, whether the bullets should always be
visible, or visible on hover only}

\item{lineStyle}{settings of the lines; \code{NULL} for default,
otherwise a named list of the form
\code{list(yvalue1 = settings1, yvalue2 = settings2, ...)} where
\code{settings1}, \code{settings2}, ... are lists created with
\code{\link{amLine}}; this can also be a
single list of settings that will be applied to each line}

\item{backgroundColor}{a color for the chart background}

\item{xAxis}{settings of the x-axis given as a list, or just a string
for the axis title; the list of settings has five possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
a field \code{adjust}, a number defining the vertical adjustment of
the axis (in pixels),
a field \code{gridLines}, a list of settings for the grid lines created
with \code{\link{amLine}},
and a field \code{breaks} to control the axis breaks, an R object created
with \code{\link{amAxisBreaks}}}

\item{yAxis}{settings of the y-axis given as a list, or just a string
for the axis title; the list of settings has five possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
a field \code{adjust}, a number defining the horizontal adjustment of
the axis (in pixels),
a field \code{gridLines}, a list of settings for the grid lines created
with \code{\link{amLine}},
and a field \code{breaks} to control the axis breaks, an R object created
with \code{\link{amAxisBreaks}}}

\item{scrollbarX}{logical, whether to add a scrollbar for the x-axis}

\item{scrollbarY}{logical, whether to add a scrollbar for the y-axis}

\item{legend}{\code{FALSE} for no legend, \code{TRUE} for a legend with
default settings, or a list of settings created with
\code{\link{amLegend}}}

\item{caption}{\code{NULL} or \code{FALSE} for no caption, a formatted
text created with \code{\link{amText}}, or a list with two fields:
\code{text}, a list created with \code{\link{amText}}, and \code{align},
can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{image}{option to include an image at a corner of the chart;
\code{NULL} or \code{FALSE} for no image, otherwise a named list with four
possible fields: the field \code{image} (required) is a list created with
\code{\link{amImage}},
the field \code{position} can be \code{"topleft"}, \code{"topright"},
\code{"bottomleft"} or \code{"bottomright"}, the field \code{hjust}
defines the horizontal adjustment, and the field \code{vjust} defines
the vertical adjustment}

\item{button}{\code{NULL} for the default, \code{FALSE} for no button,
or a list of settings created with \code{\link{amButton}}; this button is
used to replace the current data with \code{data2}}

\item{cursor}{option to add a cursor on the chart; \code{FALSE} for no
cursor, \code{TRUE} for a cursor for both axes with default settings
for the axes tooltips,
otherwise a named list with four possible fields: a field
\code{axes} to specify the axes for which the cursor is requested, can be
\code{"x"}, \code{"y"}, or \code{"xy"},
a field \code{tooltip} to set the style of the axes tooltips, this
must be a list of settings created with \code{\link{amTooltip}},
a field \code{extraTooltipPrecision}, a named list of the form
\code{list(x = i, y = j)} where \code{i} and \code{j} are the desired
numbers of additional decimals for the tooltips on the x-axis and
on the y-axis respectively, and a field \code{modifier}, a list with two
possible fields, \code{x} and \code{y}, which defines modifiers for the
values displayed in the tooltips; a modifier is some JavaScript code
given as a string, which performs a modification of a string named
\code{text}, e.g. \code{"text = '[font-style:italic]' + text + '[/]';"};
see the example for an example of \code{modifier}}

\item{width}{the width of the chart, e.g. \code{"600px"} or \code{"80\%"};
ignored if the chart is displayed in Shiny, in which case the width is
given in \code{\link{amChart4Output}}}

\item{height}{the height of the chart, e.g. \code{"400px"};
ignored if the chart is displayed in Shiny, in which case the height is
given in \code{\link{amChart4Output}}}

\item{export}{logical, whether to enable the export menu}

\item{chartId}{a HTML id for the chart}

\item{elementId}{a HTML id for the container of the chart; ignored if the
chart is displayed in Shiny, in which case the id is given by the Shiny id}
}
\description{
Create a HTML widget displaying a range area chart.
}
\note{
A color can be given by the name of a R color, the name of a CSS
color, e.g. \code{"crimson"} or \code{"silver"}, an HEX code like
\code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
like \code{"hsl(360,11,255)"}.
}
\examples{
set.seed(666)
x <- 1:20
dat <- data.frame(
  x = x,
  y1 = rnorm(20, sd = 1.5),
  y2 = rnorm(20, 10, sd = 1.5),
  z1 = rnorm(20, x+5, sd = 1.5),
  z2 = rnorm(20, x+15, sd = 1.5)
)

amRangeAreaChart(
  data = dat,
  width = "700px",
  xValue = "x",
  yValues = rbind(c("y1", "y2"), c("z1", "z2")),
  xLimits = c(1, 20),
  draggable = TRUE,
  backgroundColor = "#30303d",
  tooltip = list(
    y1 = amTooltip(
      text = "[bold]upper: {openValueY}\nlower: {valueY}[/]",
      textColor = "yellow",
      backgroundColor = "darkmagenta",
      backgroundOpacity = 0.8,
      borderColor = "rebeccapurple",
      scale = 0.9
    ),
    y2 = amTooltip(
      text = "[bold]upper: {valueY}\nlower: {openValueY}[/]",
      textColor = "yellow",
      backgroundColor = "darkmagenta",
      backgroundOpacity = 0.8,
      borderColor = "rebeccapurple",
      scale = 0.9
    ),
    z1 = amTooltip(
      text = "[bold]upper: {openValueY}\nlower: {valueY}[/]",
      textColor = "white",
      backgroundColor = "darkred",
      backgroundOpacity = 0.8,
      borderColor = "crimson",
      scale = 0.9
    ),
    z2 = amTooltip(
      text = "[bold]upper: {valueY}\nlower: {openValueY}[/]",
      textColor = "white",
      backgroundColor = "darkred",
      backgroundOpacity = 0.8,
      borderColor = "crimson",
      scale = 0.9
    )
  ),
  bullets = list(
    y1 = amCircle(color = "yellow", strokeColor = "olive"),
    y2 = amCircle(color = "yellow", strokeColor = "olive"),
    z1 = amCircle(color = "orangered", strokeColor = "darkred"),
    z2 = amCircle(color = "orangered", strokeColor = "darkred")
  ),
  alwaysShowBullets = FALSE,
  lineStyle = list(
    y1 = amLine(color = "yellow", width = 3, tensionX = 0.8, tensionY = 0.8),
    y2 = amLine(color = "yellow", width = 3, tensionX = 0.8, tensionY = 0.8),
    z1 = amLine(color = "orangered", width = 3, tensionX = 0.8, tensionY = 0.8),
    z2 = amLine(color = "orangered", width = 3, tensionX = 0.8, tensionY = 0.8)
  ),
  areas = list(
    list(name = "y1-y2", color = "blue", opacity = 0.2),
    list(name = "z1-z2", color = "red", opacity = 0.2)
  ),
  cursor = list(
    tooltip = amTooltip(
      backgroundColor = "silver"
    ),
    extraTooltipPrecision = list(x = 0, y = 2),
    modifier = list(y = "text = parseFloat(text).toFixed(2);")
  ),
  chartTitle = amText(text = "Range area chart",
                      color = "whitesmoke",
                      fontWeight = "bold"),
  xAxis = list(title = amText(text = "Observation",
                              fontSize = 20,
                              color = "silver"),
               labels = amAxisLabels(color = "whitesmoke",
                                     fontSize = 17),
               adjust = 5),
  yAxis = list(title = amText(text = "Value",
                              fontSize = 20,
                              color = "silver"),
               labels = amAxisLabels(color = "whitesmoke",
                                     fontSize = 17),
               gridLines = amLine(color = "antiquewhite",
                                  opacity = 0.4, width = 1)),
  Xformatter = "#",
  Yformatter = "#.00",
  image = list(
    image = amImage(
      href = tinyIcon("react", backgroundColor = "transparent"),
      width = 40, height = 40
    ),
    position = "bottomleft", hjust = 2, vjust = -2
  ),
  theme = "dark")
}
