% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{updateAmPercentageBarChart}
\alias{updateAmPercentageBarChart}
\title{Update the data of a 100\% stacked bar chart}
\usage{
updateAmPercentageBarChart(session, outputId, data)
}
\arguments{
\item{session}{the Shiny \code{session} object}

\item{outputId}{the output id passed on to \code{\link{amChart4Output}}}

\item{data}{new data; if it is not valid, then nothing will happen (in order
to be valid it must have the same structure as the data passed on to
\code{\link{amPercentageBarChart}}); in this
case check the JavaScript console, it will report the encountered issue}
}
\description{
Update the data of a 100\% staced bar chart in a Shiny app
  (\code{\link{amPercentageBarChart}}).
}
\examples{
library(rAmCharts4)
library(shiny)

dat <- data.frame(
  country = c("Australia", "Canada", "France", "Germany"),
  "35-44" = c(2, 2, 3, 3),
  "45-54" = c(9, 5, 7, 6),
  "55+"   = c(8, 4, 6, 5),
  check.names = FALSE
)

newdat <- data.frame(
  country = c("Australia", "Canada", "France", "Germany"),
  "35-44" = c(3, 2, 3, 4),
  "45-54" = c(7, 3, 5, 5),
  "55+"   = c(7, 4, 5, 3),
  check.names = FALSE
)


ui <- fluidPage(
  br(),
  actionButton("update", "Update", class = "btn-primary"),
  br(), br(),
  amChart4Output("pbarchart", width = "650px", height = "470px")
)

server <- function(input, output, session){

  output[["pbarchart"]] <- renderAmChart4({
    amPercentageBarChart(
      dat,
      category = "country",
      values = c("35-44", "45-54", "55+"),
      chartTitle = "Profit by country and age breakdowns",
      xAxis = "Country",
      yAxis = "Profit",
      theme = "moonrisekingdom",
      legend = amLegend(position = "right")
    )
  })

  observeEvent(input[["update"]], {
    updateAmPercentageBarChart(session, "pbarchart", newdat)
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
