% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_utility.R
\name{regression_utility}
\alias{regression_utility}
\title{regression_utility helper function}
\usage{
regression_utility(
  data,
  samplelocusname,
  locus_id = NULL,
  rv,
  mode = NULL,
  logfilename,
  minmax,
  seed = 1234
)
}
\arguments{
\item{data}{A data.table object that contains the calibration data.}

\item{samplelocusname}{A character string. In type 1 data: locus name -
name of the gene locus under investigation. In type 2 data: sample name -
name of the sample under investigation.}

\item{locus_id}{A character string. Default: NULL. ID of the respective
locus (only used in type 2 correction).}

\item{rv}{A list object. A list that contains additional objects needed
for the algorithms.}

\item{mode}{A character string. Default: NULL. Used to indicate "corrected"
calibration data.}

\item{logfilename}{A character string. Path to a file to save the log
messages (default = paste0(tempdir(), "/log.txt")).}

\item{minmax}{A logical, indicating which equations are used for
BiasCorrection (default: FALSE). If TRUE, equations are used that include
the respective minima and maxima of the provided data.}

\item{seed}{A integer value. The seed used when solving the unknowns in the
hyperbolic regression equation and the cubic regression equation.
Important for reproducibility (default: 1234).}
}
\value{
The function performs the regression calculations and returns
  the results in a list.
}
\description{
Internal function to carry out the regression calculations.
}
\examples{
# define list object to save all data
rv <- list()
rv$minmax <- TRUE
rv$selection_method <- "RelError"
rv$sample_locus_name <- "Test"
rv$seed <- 1234

# define logfilename
logfilename <- paste0(tempdir(), "/log.txt")

# import experimental file
exp_type_1 <- rBiasCorrection::example.data_experimental
rv$fileimport_experimental <- exp_type_1$dat

# import calibration file
cal_type_1 <- rBiasCorrection::example.data_calibration
rv$fileimport_calibration <- cal_type_1$dat
rv$vec_cal <- cal_type_1$vec_cal

# perform regression
regression_results <- regression_utility(
  rv$fileimport_calibration,
  "Testlocus",
  locus_id = NULL,
  rv = rv,
  mode = NULL,
  logfilename,
  minmax = rv$minmax,
  seed = rv$seed
)
length(regression_results)
class(regression_results)

}
