/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.util;

import java.util.ArrayList;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class TestContextResourceUtils {
    private static final String SLASH = "/";

    private TestContextResourceUtils() {
    }

    public static String[] convertToClasspathResourcePaths(Class<?> clazz, String ... paths) {
        String[] convertedPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            convertedPaths[i] = path.startsWith(SLASH) ? "classpath:" + path : (!ResourcePatternUtils.isUrl((String)path) ? "classpath:/" + StringUtils.cleanPath((String)(ClassUtils.classPackageAsResourcePath(clazz) + SLASH + path)) : StringUtils.cleanPath((String)path));
        }
        return convertedPaths;
    }

    public static Resource[] convertToResources(ResourceLoader resourceLoader, String ... paths) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (String path : paths) {
            list.add(resourceLoader.getResource(path));
        }
        return list.toArray(new Resource[list.size()]);
    }
}

