/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.freemarker;

import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class FreeMarkerTemplateAvailabilityProvider
implements TemplateAvailabilityProvider {
    @Override
    public boolean isTemplateAvailable(String view, Environment environment, ClassLoader classLoader, ResourceLoader resourceLoader) {
        if (ClassUtils.isPresent((String)"freemarker.template.Configuration", (ClassLoader)classLoader)) {
            String loaderPath = environment.getProperty("spring.freemarker.path", "classpath:/templates/");
            String prefix = environment.getProperty("spring.freemarker.prefix", "");
            String suffix = environment.getProperty("spring.freemarker.suffix", ".ftl");
            return resourceLoader.getResource(loaderPath + prefix + view + suffix).exists();
        }
        return false;
    }
}

