% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_version_number.R
\name{create_version_number}
\alias{create_version_number}
\title{Create version number}
\usage{
create_version_number(
  download_date = NULL,
  version = NULL,
  major = 0,
  minor = "1",
  patch = 0
)
}
\arguments{
\item{download_date}{(Optional) download_date
This can either be a date or datetime
but must include the full year
\emph{e.g} from
\code{Sys.Date()
2020-01-01}
Or from
\code{Sys.time()
2020-01-01 00:00:00 BST}
note: also accepts / delimited dates
\emph{e.g} \code{01/02/2020}
or \code{2020/01/01}
and accepts date without delimiters but assumes ddmmyyyy or yyyymmdd
\emph{e.g.} \code{20200201}}

\item{version}{version number using major.minor.patch numbering
\emph{e.g.} \code{0.1.0}
or major.patch
\emph{e.g.} \code{0.0}}

\item{major}{major number if not using \code{version}}

\item{minor}{minor number if not using \code{date}}

\item{patch}{patch number if not using \code{version}}
}
\value{
returns a character vector in the format of \code{major.minor.patch}
\emph{e.g.} \code{0.20200101.0}
}
\description{
Creates a version number from either \emph{a date and a version}
\strong{or} \emph{a date and major and patch}
\strong{or} \emph{major minor patch}.
If no parameters are supplied a default version is returned
\code{0.1.0}
This function prioritizes download date and version over all other parameters
}
\concept{create functions}
