# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Given item set, item representation vector, and item ratings, find a subset with better relevance-diversity trade-off.
#'
#' @param item_representations matrix with nrow = num_items and ncol = feature_dim
#' @param ratings matrix with nrow = num_items and ncol = 1
#' @param n int. subset size
#'
#' @return dataframe with 2 columns: id & gain
#' @export
#'
#' @examples
#' library(rDppDiversity)
#' bestSubset(matrix(c(-0.1, -0.15, 0.2, 0.3, -0.2, -0.3), nrow=3, ncol=2, byrow=TRUE), c(1, 2, 3), 3)
bestSubset <- function(item_representations, ratings, n) {
  .Call('_rDppDiversity_bestSubset', PACKAGE = 'rDppDiversity', item_representations, ratings, n)
}

#' Machine learning algorithm to learn item representations maximizing log likelihood under DPP assumption.
#'
#' @param train_data_path A string for text file path. Each line: item_id,item_id,item_id
#' @param emb_size int. ColumnNum for model parameter. While RowNum = number of uniq items parsed in train_data_path
#' @param regularization float. Default = 0.1
#' @param learning_rate float. Generally begin with small learning_rate will train better.
#' @param neg_sample_cnt int.
#' @param epoch int.
#'
#' @return A list contains 1) learned item embedding matrix; 2) item names vector; 3) log likelihood on each training step vector.
#' @export
#'
#' @examples
#' library(rDppDiversity)
#' data_path=system.file("extdata", "data.txt", package = "rDppDiversity")
#' learnItemEmb(data_path, 3, 0.1, 0.01, 0, 10)
learnItemEmb <- function(train_data_path, emb_size, regularization, learning_rate, neg_sample_cnt, epoch) {
  .Call('_rDppDiversity_learnItemEmb', PACKAGE = 'rDppDiversity', train_data_path, emb_size, regularization, learning_rate, neg_sample_cnt, epoch)
}
