% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rEDM_package.R
\docType{package}
\name{rEDM}
\alias{rEDM}
\alias{rEDM-package}
\title{Applications of empirical dynamic modeling from time series.}
\description{
The \pkg{rEDM} package is a new implementation of EDM algorithms 
  based on research software previously developed for internal use in the 
  Sugihara Lab (UCSD/SIO). Contains C++ compiled objects that use time delay 
  embedding to perform state-space reconstruction and nonlinear forecasting 
  and an R interface to those objects using \pkg{Rcpp}. It supports both the 
  simplex projection method from Sugihara & May (1990) 
  <DOI:10.1038/344734a0> and the S-map algorithm in Sugihara (1994) 
  <DOI:10.1098/rsta.1994.0106>. In addition, this package implements 
  convergent cross mapping as described in Sugihara et al. (2012) 
  <DOI:10.1126/science.1227079> and multiview embedding as described in Ye & 
  Sugihara (2016) <DOI:10.1126/science.aag0863>.
}
\details{
This package is divided into a set of main functions to perform 
  various analyses, as well as helper functions that perform minor tasks, 
  such as generate data, processing output, and wrapper functions.

\strong{Main Functions}: 
  \itemize{
    \item \code{\link{simplex}} - simplex projection for univariate forecasting
    \item \code{\link{s_map}} - S-maps for univariate forecasting
    \item \code{\link{block_lnlp}} - simplex or S-map forecasting with a generic reconstructed state-space
    \item \code{\link{ccm}} - convergent cross mapping (causal inference)
    \item \code{\link{multiview}} - multi-model approach to forecasting
    \item \code{\link{tde_gp}} - Gaussian Processes for univariate forecasting
    \item \code{\link{block_gp}} - Gaussian Processes with a generic reconstructed state-space
  }
\strong{Helper Functions}: 
  \itemize{
    \item \code{\link{compute_stats}} - compute forecast skill metrics
    \item \code{\link{ccm_means}} - aggregate output of \code{\link{ccm}} by library size (`lib_size`)
    \item \code{\link{make_surrogate_data}} - generate surrogate time series
    \item \code{\link{test_nonlinearity}} - test for nonlinearity using surrogate time series
  }
}
\author{
\strong{Maintainer}: Sugihara Lab

  \strong{Authors}: Hao Ye, Adam Clark, Ethan Deyle, Steve Munch
  
  \strong{Contributors}: Oliver Keyes, Jun Cai, Ethan White, Jane Cowles, 
    James Stagge, Yair Daon, Andrew Edwards, George Sugihara
}
\keyword{package}
