% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{num_events}
\alias{num_events}
\title{Find number of episodes below a given glucose value for a given amount of time}
\usage{
num_events(x, times, thresh = 55, len = 15, gap = 5)
}
\arguments{
\item{x}{vector of glucose readings}

\item{times}{vector of corresponding times, in minutes}

\item{thresh}{glucoses below this threshold are considered as part of an episode. Default is 55}

\item{len}{minimum length of an episode. Default is 15}

\item{gap}{typical gap between CGM measurements, in minutes. Default is 5}
}
\value{
The integer number of events for a given dataset of glucose measurements and times.
}
\description{
Find number of episodes below a given glucose value for a given amount of time
}
\examples{
num_events(x=c(rep(100, 10), rep(120, 10), 105, 85), times=seq(0, 1260, 60),
thresh=55, len=15, gap=5)
}
