% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.quality.R
\name{msc.quality}
\alias{msc.quality}
\title{Check the quality of the assembly}
\usage{
msc.quality(mapstats, groups)
}
\arguments{
\item{mapstats}{a character vector containing the file names of mapping statistics (output of KOMICS).}

\item{groups}{a vector specifying to which group (e.g. species) the samples belong to.}
}
\value{
\item{all}{a table merging mapping statistics of all samples. Mapping statistics include the number of mapped reads (MR), mapped reads with high quality (MR_HQ), CSB3-containing mapped reads (MR_CSB3) and CSB3-containing mapped read with high quality (MR_CSB3_HQ).}
\item{proportions}{a list of tables containing the proportion of previous mentioned items.}
\item{plots}{barplots visualizing previous results.}
}
\description{
The msc.quality function allows you to summarise mapping statistics generated by KOMCIS.
To check whether minicircles have been assembled successfully, read, mapped read and high quality mapped read frequencies are inspected.
The proportion of (near-)perfect alignments of CSB3-containing reads are herefor an important measure.
}
\examples{
data(exData)

### run function
map <- msc.quality(mapstats = system.file("extdata", exData$mapstats, package = "rKOMICS"),
                   exData$species)

lapply(map$proportions, mean)$MR_HQ 
lapply(map$proportions, mean)$MR_CSB3_HQ

### visualize results
barplot(map$proportions$MR)

}
