% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateData.R
\name{simulateData}
\alias{simulateData}
\title{Simulate data as measured by a Placido disk corneal topographer}
\usage{
simulateData(
  rings = 15,
  pointsPerRing = 256,
  diameter = 12,
  ringRadiiPerturbation = 0,
  maximumMireDisplacement = 0,
  mireDisplacementAngle = 0,
  mireDisplacementPerturbation = 0,
  ellipticAxesRatio = 1,
  ellipticRotation = 0,
  overallNoise = 0,
  seed = 0
)
}
\arguments{
\item{rings}{The total number of rings of mires in the sample (typically in the range 18-30, around 24).}

\item{pointsPerRing}{The number of points to be sampled in each ring (typically 256 or 360).}

\item{diameter}{Diameter of the simulated dataset (in mm, typically around 8-12 mm).}

\item{ringRadiiPerturbation}{Stochastical perturbation of the mires radii distribution (typically between 0 (no perturbation) and 1 (high perturbation)).}

\item{maximumMireDisplacement}{Mires displacement, drift or off-centering (expressed in mm, and should be a reasonable number according to the diameter used.}

\item{mireDisplacementAngle}{Direction of mires drift (an angle in degrees, typically in the range 0-360 with 0 meaning positive x direction).}

\item{mireDisplacementPerturbation}{Stochastical perturbation of the mires drift (typically between 0 (no perturbation) and 1 (high perturbation)).}

\item{ellipticAxesRatio}{Rate or quotient between the major and minor axes of each ellipse (related to the ellipse eccentricity; 1 means a perfect circle (no eccentricity)).}

\item{ellipticRotation}{Direction or orientation of the ellipses (an angle in degrees, typically in the range 0-360 with 0 meaning positive x direction).}

\item{overallNoise}{Random, white noise of a certain magnitude in the Cartesian coordinates of the sampled points (relative to the diameter and the number of rings; 0 means no noise, and 1 large noise).}

\item{seed}{A seed, included for repeatability when using random perturbations.}
}
\value{
A \code{data.frame} with columns:
\tabular{lll}{
  \code{x}   \tab\tab The X Cartesian coordinates of sampled points\cr
  \code{y}   \tab\tab The Y Cartesian coordinates of sampled points\cr
  \code{ring index}  \tab\tab Number or index of the ring from which each point is sampled\cr
}
The resulting \code{data.frame} also includes in its \code{Parameters} attribute (\code{attr(result,'Parameters')}) the list of parameters used for the simulation.
}
\description{
The function \code{simulateData} permits to simulate a wide variety of datasets that appear in clinical 
practice, as a result of measuring an individual eye with a Placido disk corneal topographer 
(see \href{../doc/topographersDataFormat.html}{\code{vignette("topographersDataFormat", package = "rPACI")}}).
}
\details{
This function produces a dataset in the same format as the one read by \link[rPACI]{readCSO}
from a file, i.e., a list with three columns (x and y coordinates of each point and its ring index) and a
row per data point, according to the function parameters (by default, 6144 rows or data points).

See \href{../doc/simulating.html}{\code{vignette("simulating", package = "rPACI")}} for additional details.
The examples included there show different ways of using \code{simulateData}, by adding different transformations
or perturbations to the basic circular pattern. Some of the obtained patterns can correlate with certain
clinical conditions, such as keratoconus, comma, or others.

The simulated dataset can be later used according to the package workflow explained in the
\href{../doc/packageUsage.html}{\code{vignette("packageUsage", package = "rPACI")}}.
}
\examples{
# Simulating with default parameters
dataset = simulateData()  
plot(dataset$x,dataset$y)

# Simulating with 20 rings and a diameter of 8 mm
dataset = simulateData(rings = 20, diameter = 8)
plot(dataset$x,dataset$y)

# Simulating with default parameters and 500 points per ring (15x500 points)
dataset = simulateData(pointsPerRing = 500)
plot(dataset$x,dataset$y)

# Simulating an elliptic dataset, with ellipses axis ratio of 0.8 and an orientation of 45 degrees.
dataset = simulateData(ellipticAxesRatio = 0.8, ellipticRotation = 45)
plot(dataset$x,dataset$y)

# To see the parameters used in the simulation, access the 'Parameters' attribute:
attr(dataset,'Parameters')
}
