% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_fasta_text_to_list.R
\name{parse_fasta_text_to_list}
\alias{parse_fasta_text_to_list}
\title{Parse Raw FASTA Text into a List of Sequences}
\usage{
parse_fasta_text_to_list(raw_fasta_text)
}
\arguments{
\item{raw_fasta_text}{A string containing the raw FASTA text to be parsed.}
}
\value{
A list of FASTA sequences, each as a separate list element with entity ID, chains, sequence, and header.
}
\description{
This function parses raw FASTA text into a structured list format.
It splits the FASTA text into individual sequences and extracts relevant information
like entity ID, chains, sequence, and header.
}
\examples{
raw_fasta_text <- ">1XYZ|Chains A, B\nMVLSPADKT...\n>2XYZ|Chain C\nGVLSADFT..."
fasta_list <- parse_fasta_text_to_list(raw_fasta_text)
}
