% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{tg.removeIntervalBothBoundaries}
\alias{tg.removeIntervalBothBoundaries}
\title{tg.removeIntervalBothBoundaries}
\usage{
tg.removeIntervalBothBoundaries(tg, tierInd, index)
}
\arguments{
\item{tg}{TextGrid object}

\item{tierInd}{tier index or "name"}

\item{index}{index of the interval}
}
\value{
TextGrid object
}
\description{
Remove both left and right boundary of interval of the given index in
Interval tier. In fact, this operation concatenate three intervals into
one (and their labels). It cannot be applied to the first and the last
interval because they contain beginning or end boundary of the tier.
E.g., let's assume interval 1-2-3. We remove both boundaries of the
2nd interval. The result is one interval 123.
If we do not want to concatenate labels (we wanted to remove the label
including its interval), we can set the label of the second interval
to the empty string "" before this operation.
If we only want to remove the label of interval "without concatenation",
i.e., the desired result is 1-empty-3, it is not this operation of
removing boundaries. Just set the label of the second interval to the
empty string "".
}
\examples{
\dontrun{
tg <- tg.sample()
tg.plot(tg)
tg2 <- tg.removeIntervalBothBoundaries(tg, "word", 3)
tg.plot(tg2)
}
}
\seealso{
\code{\link{tg.removeIntervalLeftBoundary}}, \code{\link{tg.removeIntervalRightBoundary}}, \code{\link{tg.insertBoundary}}, \code{\link{tg.insertInterval}}
}
