% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter}
\alias{filter}
\title{Filtering of Point Clouds}
\usage{
filter(
  cloud,
  method,
  radius,
  min_neighbours,
  k,
  nSigma,
  edge_length,
  distance = "euclidean",
  threads = 1L,
  verbose = FALSE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{cloud}{A \code{data.table} contain three columns representing the *XYZ* coordinates.}

\item{method}{A filtering method to use. It most be \code{"SOR"}, \code{"min_neighbors"}, or \code{"min_neighbors"}.}

\item{radius}{A \code{numeric} vector representing the radius of the sphere to consider. This needs to be used if \code{method = "voxel_center"}.}

\item{min_neighbours}{An \code{integer} representing the minimum number of neighbors to keep a given point. This needs to be used if \code{method = "min_n"}.}

\item{k}{An \code{integer} vector representing the number of neighbors to consider. This needs be used if \code{method = "SOR"}.}

\item{nSigma}{A \code{numeric} vector representing the standard deviation multiplier. This needs to be used if \code{method = "SOR"}.}

\item{edge_length}{A positive \code{numeric} vector with the voxel-edge length for the x, y, and z coordinates. This needs to be used if \code{method = "voxel_center"}.}

\item{distance}{Type of distance to calculate. \code{"euclidean"} as default. Look \code{hnsw_knn} for more options.}

\item{threads}{An \code{integer} specifying the number of threads to use for parallel processing. Experiment to see what works best for your data on your hardware.}

\item{verbose}{If TRUE, log messages to the console.}

\item{progress}{If TRUE, log a progress bar when \code{verbose = TRUE}. Tracking progress could cause a small overhead.}

\item{...}{Arguments passed to \code{hnsw_build} and \code{hnsw_search}.}
}
\value{
A \code{data.table} with the filtered points
}
\description{
Filtering of point clouds using different methods
}
\examples{

\donttest{
#Load data
data("pc_tree")

#Move pc_tree for comparison
pc_compare <- pc_tree
pc_compare$X <- pc_compare$X - 7

#SOR filter
r1 <- filter(pc_tree, method = "SOR", k = 30, nSigma = 1)
rgl::plot3d(r1, col = "red") #Filter
rgl::points3d(pc_compare, col = "black") #Original

#min_neighbours filter
r2 <- filter(pc_tree, "min_neighbors", radius = 0.02, min_neighbours = 20)
rgl::plot3d(r2, col = "red") #Filter
rgl::points3d(pc_compare, col = "black") #Original

#voxel_center filter
r3 <- filter(pc_tree, method = "voxel_center", edge_length = 0.1)
rgl::plot3d(r3, col = "red") #Filter
rgl::points3d(pc_compare, col = "black") #Original
}

}
\author{
J. Antonio Guzmán Q.
}
