% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTensor_Misc.R
\name{k_fold}
\alias{k_fold}
\title{k-mode Folding of Matrix}
\usage{
k_fold(mat, m = NULL, modes = NULL)
}
\arguments{
\item{mat}{matrix to be folded into a Tensor}

\item{m}{the index of the mode that is mapped onto the row indices}

\item{modes}{the modes of the output Tensor}
}
\value{
Tensor object with modes given by \code{modes}
}
\description{
k-mode folding of a matrix into a Tensor. This is the inverse funtion to \code{k_unfold} in the m mode. In particular, \code{k_fold(k_unfold(tnsr, m),m,getModes(tnsr))} will result in the original Tensor.
}
\details{
This is a wrapper function to \code{\link{fold}}.
}
\examples{
tnsr <- new("Tensor",3L,c(3L,4L,5L),data=runif(60))
matT2<-k_unfold(tnsr,m=2)
identical(k_fold(matT2,m=2,modes=c(3,4,5)),tnsr)
}
\references{
T. Kolda, B. Bader, "Tensor decomposition and applications". SIAM Applied Mathematics and Applications 2009.
}
\seealso{
\code{\link{k_unfold-methods}}, \code{\link{fold}}, \code{\link{unmatvec}}
}

