% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ac_get_deals.R
\name{ac_get_deals}
\alias{ac_get_deals}
\title{Retrieve all existing deals}
\usage{
ac_get_deals(
  search = NULL,
  search_field = NULL,
  title = NULL,
  stage = NULL,
  group = NULL,
  status = NULL,
  owner = NULL,
  nextdate_range = NULL,
  tag = NULL,
  tasktype = NULL,
  created_before = NULL,
  created_after = NULL,
  updated_before = NULL,
  updated_after = NULL,
  organization = NULL,
  minimum_value = NULL,
  maximum_value = NULL,
  score_greater_than = NULL,
  score_less_than = NULL,
  score = NULL
)
}
\arguments{
\item{search}{Search text to use with search_field parameter.}

\item{search_field}{Field to search for. Available values: all (All three fields: title, contact, and org), title (Deal's title), contact (Deal's primary contact's first name and last name. If search parameter has more than one word, first word is used for matching first name of contacts and rest of the words are used for matching last name of contacts.), org (Deal's primary contact's organization name).}

\item{title}{Filter by deal's title}

\item{stage}{Filter by deal's stage}

\item{group}{Filter by deal's pipeline}

\item{status}{Filter by deal's status. 0 - Open, 1 - Won, 2 - Lose.}

\item{owner}{Filter by deal's owner}

\item{nextdate_range}{Filter by deal's tasks due dates. Available values: upcoming (Deals with tasks that are due within 24 hours.), scheduled (Deals with tasks that are due in more than 24 hours), overdue (Deals with tasks that are past due dates.), no-task (Deals without any task.).}

\item{tag}{Filter by tag names associated with deal's primary contact. Available values: greater than 0 (Deals with primary contacts that have the tag with given id), -1 (Deals with primary contacts that have any tag), -2 (Deals with primary contacts that have no tag)}

\item{tasktype}{Filter by deals that have tasks with given type}

\item{created_before}{Returns deals that are created less than given date}

\item{created_after}{Returns deals that are created greater than or equal to given date}

\item{updated_before}{Returns deals that are updated less than given date}

\item{updated_after}{Returns deals that are updated greater than or equal to given date}

\item{organization}{Filter by deal's primary contact's organization's id}

\item{minimum_value}{In USD with dollar portion. Returns deals whose values are greater than or equal to given}

\item{maximum_value}{In USD with dollar portion. Returns deals whose values are less than or equal to given}

\item{score_greater_than}{In a format of <score_id>:<score_value>. Returns deals whose score value is greater than given value}

\item{score_less_than}{In a format of <score_id>:<score_value>. Returns deals whose score value is less than given value}

\item{score}{In a format of <score_id>:<score_value>. Returns deals whose score value is equal to given value}
}
\value{
tibble with deals data
}
\description{
Retrieve all existing deals
}
\examples{
\dontrun{
Sys.setenv('ACTIVECAMPAGN_API_TOKEN' = "YOUR_TOKEN")
Sys.setenv('ACTIVECAMPAGN_API_URL' = "https://<your-account>.api-us1.com")

deals <- ac_get_deals()
}
}
\seealso{
\href{https://developers.activecampaign.com/reference#deal}{Deals}
}
