% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{combine_data}
\alias{combine_data}
\title{Combine datasets using dplyr's bind and join functions}
\usage{
combine_data(x, y, by = "", add = "", type = "inner_join",
  data_filter = "", ...)
}
\arguments{
\item{x}{Dataset}

\item{y}{Dataset to combine with x}

\item{by}{Variables used to combine `x` and `y`}

\item{add}{Variables to add from `y`}

\item{type}{The main bind and join types from the dplyr package are provided. \bold{inner_join} returns all rows from x with matching values in y, and all columns from x and y. If there are multiple matches between x and y, all match combinations are returned. \bold{left_join} returns all rows from x, and all columns from x and y. If there are multiple matches between x and y, all match combinations are returned. \bold{right_join} is equivalent to a left join for datasets y and x. \bold{full_join} combines two datasets, keeping rows and columns that appear in either. \bold{semi_join} returns all rows from x with matching values in y, keeping just columns from x. A semi join differs from an inner join because an inner join will return one row of x for each matching row of y, whereas a semi join will never duplicate rows of x. \bold{anti_join} returns all rows from x without matching values in y, keeping only columns from x. \bold{bind_rows} and \bold{bind_cols} are also included, as are \bold{intersect}, \bold{union}, and \bold{setdiff}. See \url{https://radiant-rstats.github.io/docs/data/combine.html} for further details}

\item{data_filter}{Expression used to filter the dataset. This should be a string (e.g., "price > 10000")}

\item{...}{further arguments passed to or from other methods}
}
\value{
If list `r_data` exists the combined dataset is added as `name`. Else the combined dataset will be returned as `name`
}
\description{
Combine datasets using dplyr's bind and join functions
}
\details{
See \url{https://radiant-rstats.github.io/docs/data/combine.html} for an example in Radiant
}
\examples{
avengers \%>\% combine_data(superheroes, type = "bind_cols")
combine_data(avengers, superheroes, type = "bind_cols")
avengers \%>\% combine_data(superheroes, type = "bind_rows")
avengers \%>\% combine_data(superheroes, add = "publisher", type = "bind_rows")

}
