% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbt.R
\name{plot.gbt}
\alias{plot.gbt}
\title{Plot method for the gbt function}
\usage{
\method{plot}{gbt}(x, plots = "", nrobs = Inf, shiny = FALSE, custom = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{gbt}}}

\item{plots}{Plots to produce for the specified Gradient Boosted Tree model. Use "" to avoid showing any plots (default). Options are ...}

\item{nrobs}{Number of data points to show in scatter plots (-1 for all)}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the gbt function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/gbt.html} for an example in Radiant
}
\examples{
result <- gbt(titanic, "survived", c("pclass", "sex"), lev = "Yes")

}
\seealso{
\code{\link{gbt}} to generate results

\code{\link{summary.gbt}} to summarize results

\code{\link{predict.gbt}} for prediction
}
