% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnl.R
\name{predict.mnl}
\alias{predict.mnl}
\title{Predict method for the mnl function}
\usage{
\method{predict}{mnl}(
  object,
  pred_data = NULL,
  pred_cmd = "",
  pred_names = "",
  dec = 3,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{object}{Return value from \code{\link{mnl}}}

\item{pred_data}{Provide the dataframe to generate predictions (e.g., ketchup). The dataset must contain all columns used in the estimation}

\item{pred_cmd}{Generate predictions using a command. For example, `pclass = levels(pclass)` would produce predictions for the different levels of factor `pclass`. To add another variable, create a vector of prediction strings, (e.g., c('pclass = levels(pclass)', 'age = seq(0,100,20)')}

\item{pred_names}{Names for the predictions to be stored. If one name is provided, only the first column of predictions is stored. If empty, the levels in the response variable of the mnl model will be used}

\item{dec}{Number of decimals to show}

\item{envir}{Environment to extract data from}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the mnl function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/mnl.html} for an example in Radiant
}
\examples{
result <- mnl(
  ketchup,
  rvar = "choice",
  evar = c("price.heinz28", "price.heinz32", "price.heinz41", "price.hunts32"),
  lev = "heinz28"
)
predict(result, pred_cmd = "price.heinz28 = seq(3, 5, 0.1)")
predict(result, pred_data = slice(ketchup, 1:20))

}
\seealso{
\code{\link{mnl}} to generate the result

\code{\link{summary.mnl}} to summarize results
}
