% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalbin.R
\name{profit}
\alias{profit}
\title{Calculate Profit based on cost:margin ratio}
\usage{
profit(pred, rvar, lev, cost = 1, margin = 2)
}
\arguments{
\item{pred}{Prediction or predictor}

\item{rvar}{Response variable}

\item{lev}{The level in the response variable defined as success}

\item{cost}{Cost per treatment (e.g., mailing costs)}

\item{margin}{Margin, or benefit, per 'success' (e.g., customer purchase). A cost:margin ratio of 1:2 implies
the cost of False Positive are equivalent to the benefits of a True Positive}
}
\value{
profit
}
\description{
Calculate Profit based on cost:margin ratio
}
\examples{
profit(runif(20000), dvd$buy, "yes", cost = 1, margin = 2)
profit(ifelse(dvd$buy == "yes", 1, 0), dvd$buy, "yes", cost = 1, margin = 20)
profit(ifelse(dvd$buy == "yes", 1, 0), dvd$buy)
}
