% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjoint.R
\name{predict.conjoint}
\alias{predict.conjoint}
\title{Predict method for the conjoint function}
\usage{
\method{predict}{conjoint}(object, pred_data = "", pred_cmd = "",
  conf_lev = 0.95, se = FALSE, dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{conjoint}}}

\item{pred_data}{Name of the dataset to use for prediction}

\item{pred_cmd}{Command used to generate data for prediction}

\item{conf_lev}{Confidence level used to estimate confidence intervals (.95 is the default)}

\item{se}{Logical that indicates if prediction standard errors should be calculated (default = FALSE)}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the conjoint function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/conjoint.html} for an example in Radiant
}
\examples{
result <- conjoint("mp3", rvar = "Rating", evar = "Memory:Shape")
predict(result, pred_data = "mp3")

}
\seealso{
\code{\link{conjoint}} to generate the result

\code{\link{summary.conjoint}} to summarize results

\code{\link{plot.conjoint}} to plot results
}
