% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/glm_reg.R
\name{summary.glm_reg}
\alias{summary.glm_reg}
\title{Summary method for glm_reg}
\usage{
\method{summary}{glm_reg}(object, glm_sum_check = "", glm_conf_level = 0.95,
  glm_test_var = "", ...)
}
\arguments{
\item{object}{Return value from \code{\link{glm_reg}}}

\item{glm_sum_check}{Optional output or estimation parameters. "rsme" to show the root mean squared error. "sumsquares" to show the sum of squares table. "vif" to show multicollinearity diagnostics. "confint" to show coefficient confidence interval estimates.}

\item{glm_conf_level}{Confidence level to use for coefficient and odds confidence intervals (.95 is the default)}

\item{glm_test_var}{Variables to evaluate in model comparison (i.e., a competing models Chi-squared test)}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summary method for glm_reg
}
\details{
See \url{http://mostly-harmless.github.io/radiant/quant/glm_reg.html} for an example in Radiant
}
\examples{
result <- glm_reg("titanic", "survived", "pclass", glm_levels = "Yes")
summary(result, glm_test_var = "pclass")
res <- glm_reg("titanic", "survived", c("pclass","sex"), glm_int_var="pclass:sex", glm_levels="Yes")
summary(res, glm_sum_check = c("vif","confint","odds"))
}
\seealso{
\code{\link{glm_reg}} to generate the results

\code{\link{plot.glm_reg}} to plot the results

\code{\link{predict.glm_reg}} to generate predictions
}

