% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed-vertex.R
\name{embed_google_vertex}
\alias{embed_google_vertex}
\title{Embed using Google Vertex API platform}
\usage{
embed_google_vertex(
  x,
  model,
  location,
  project_id,
  task_type = "RETRIEVAL_QUERY"
)
}
\arguments{
\item{x}{x can be:
\itemize{
\item A character vector, in which case a matrix of embeddings is returned.
\item A data frame with a column named \code{text}, in which case the dataframe is
returned with an additional column named \code{embedding}.
\item Missing or \code{NULL}, in which case a function is returned that can be called
to get embeddings. This is a convenient way to partial in additional arguments like \code{model},
and is the most convenient way to produce a function that can be passed to the \code{embed} argument of \code{ragnar_store_create()}.
}}

\item{model}{Character specifying the embedding model.
See supported models in \href{https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/text-embeddings-api}{Text embeddings API}}

\item{location}{Location, e.g. \code{us-east1}, \code{me-central1}, \code{africa-south1}.}

\item{project_id}{Project ID.}

\item{task_type}{Used to convey intended downstream application to help the
model produce better embeddings. If left blank, the default used is \code{"RETRIEVAL_QUERY"}.
\itemize{
\item \code{"RETRIEVAL_QUERY"}
\item \code{"RETRIEVAL_DOCUMENT"}
\item \code{"SEMANTIC_SIMILARITY"}
\item \code{"CLASSIFICATION"}
\item \code{"CLUSTERING"}
\item \code{"QUESTION_ANSWERING"}
\item \code{"FACT_VERIFICATION"}
\item \code{"CODE_RETRIEVAL_QUERY"}
For more information about task types, see \href{https://cloud.google.com/vertex-ai/generative-ai/docs/embeddings/task-types}{Choose an embeddings task type}.
}}
}
\description{
Embed using Google Vertex API platform
}
\examples{
\dontrun{
embed_google_vertex(
 "hello world",
 model="gemini-embedding-001",
 project = "<your-project-id>",
 location = "us-central1"
)
}
}
