% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{ragnar_retrieve_vss}
\alias{ragnar_retrieve_vss}
\title{Vector Similarity Search Retrieval}
\usage{
ragnar_retrieve_vss(
  store,
  query,
  top_k = 3L,
  ...,
  method = "cosine_distance",
  query_vector = store@embed(query),
  filter
)
}
\arguments{
\item{store}{A \code{RagnarStore} object returned by \code{ragnar_store_connect()} or \code{ragnar_store_create()}.}

\item{query}{Character. The query string to embed and use for similarity
search.}

\item{top_k}{Integer. Maximum number of document chunks to retrieve.
Defaults to 3.}

\item{...}{Additional arguments passed to methods.}

\item{method}{Character. Similarity method to use: \code{"cosine_distance"},
\code{"euclidean_distance"}, or \code{"negative_inner_product"}. Defaults to
\code{"cosine_distance"}.}

\item{query_vector}{Numeric vector. The embedding for \code{query}.
Defaults to \code{store@embed(query)}.}

\item{filter}{Optional. A filter expression evaluated with
\code{dplyr::filter()}.}
}
\value{
A \code{tibble} with the top_k retrieved chunks,
ordered by \code{metric_value}.
}
\description{
Computes a similarity measure between the query and the document embeddings
and uses this similarity to rank and retrieve document chunks.
}
\details{
Supported methods:
\itemize{
\item \strong{cosine_distance} – cosine of the angle between two vectors.
\item \strong{euclidean_distance} – L2 distance between vectors.
\item \strong{negative_inner_product} – negative sum of element-wise products.
}

If \code{filter} is supplied, the function first performs the similarity
search, then applies the filter in an outer SQL query. It uses the HNSW
index when possible and falls back to a sequential scan for large result
sets or filtered queries.
}
\note{
The results are not re-ranked after identifying the unique values.
}
\examples{
\dontshow{if ((rlang::is_installed("dbplyr") && nzchar(Sys.getenv("OPENAI_API_KEY")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Build a small store with categories
store <- ragnar_store_create(
  embed = \(x) ragnar::embed_openai(x, model = "text-embedding-3-small"),
  extra_cols = data.frame(category = character()),
  version = 1 # store text chunks directly
)

ragnar_store_insert(
  store,
  data.frame(
    category = c(rep("pets", 3), rep("dessert", 3)),
    text     = c("playful puppy", "sleepy kitten", "curious hamster",
                 "chocolate cake", "strawberry tart", "vanilla ice cream")
  )
)
ragnar_store_build_index(store)

# Top 3 chunks without filtering
ragnar_retrieve(store, "sweet")

# Combine filter with similarity search
ragnar_retrieve(store, "sweet", filter = category == "dessert")
\dontshow{\}) # examplesIf}
}
\seealso{
Other ragnar_retrieve: 
\code{\link{ragnar_retrieve}()},
\code{\link{ragnar_retrieve_bm25}()},
\code{\link{ragnar_retrieve_vss_and_bm25}()}
}
\concept{ragnar_retrieve}
