% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rags2ridges.R
\name{GGMmutualInfo}
\alias{GGMmutualInfo}
\title{Mutual information between two sets of variates within a multivariate normal
distribution}
\usage{
GGMmutualInfo(S, split1)
}
\arguments{
\item{S}{A positive-definite covariance \code{matrix}.}

\item{split1}{A \code{numeric}, indicating the variates (by column number)
forming the first split. The second split is automatically formed from its
complement.}
}
\value{
A \code{numeric}, the mutual information between the variates
forming \code{split1} and those forming its complement.
}
\description{
Function computing the mutual information between two exhaustive and
mutually exclusive splits of a set of multivariate normal random variables.
}
\examples{

# create a covariance matrix
Sigma <- covML(matrix(rnorm(100), ncol=5))

# impulse response analysis
GGMmutualInfo(Sigma, c(1,2))

}
\references{
Cover, T.M., Thomas, J.A. (2012), Elements of information
theory.
}
\seealso{
\code{\link{covML}}, \code{\link{ridgeP}}.
}
\author{
Wessel N. van Wieringen, Carel F.W. Peeters <carel.peeters@wur.nl>
}
