% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{implied_volatility_with_term_struct}
\alias{implied_volatility_with_term_struct}
\title{Find the implied volatility of a european-exercise option with term structures}
\usage{
implied_volatility_with_term_struct(option_price, callput, S0, K, time, ...,
  starting_volatility_estimate = 0.5, relative_tolerance = 1e-06,
  max.iter = 100, max_vola = 4)
}
\arguments{
\item{option_price}{Option price to match}

\item{callput}{1 for calls, -1 for puts}

\item{S0}{initial underlying price}

\item{K}{strike}

\item{time}{Time to expiration}

\item{...}{Further arguments to be passed on to \code{black_scholes_on_term_structures}}

\item{starting_volatility_estimate}{The Newton method's original guess}

\item{relative_tolerance}{Relative tolerance in instrument price defining the root-finder halting condition}

\item{max.iter}{Maximum number of root-finder iterations allowed}

\item{max_vola}{Maximum volatility to try}
}
\value{
Estimated volatility
}
\description{
Use the Black-Scholes formula to generate European option values and run them
  through Newton's method until a constant volatility matching the provided
  option price has been found.
}
\details{
Differs from \code{implied_volatility} by calling \code{black_scholes_on_term_structures} for
  pricing, thereby allowing term structures of rates, and a nontrivial \code{survival_probability_fcn}
}
\examples{
## Dividends
divs = data.frame(time=seq(from=0.11, to=2, by=0.25),
                  fixed=seq(1.5, 1, length.out=8),
                  proportional = seq(1, 1.5, length.out=8))
surv_prob_fcn = function(T, t, ...) {
  exp(-0.07 * (T - t)) }
disc_factor_fcn = function(T, t, ...) {
  exp(-0.03 * (T - t)) }
implied_volatility_with_term_struct(
    option_price = 12, S0 = 150, callput=PUT,
    K = 147.50, time=1.5,
    discount_factor_fcn=disc_factor_fcn,
    survival_probability_fcn=surv_prob_fcn,
    dividends=divs)
}
\seealso{
\code{\link{implied_volatility}} for simpler cases with constant
  parameters, \code{\link{black_scholes_on_term_structures}} for the underlying
  pricing algorithm, \code{\link{implied_volatilities_with_rates_struct}} when
  neither volatilities nor survival probabilities have a nontrivial term structure

Other Equity Independent Default Intensity: \code{\link{american_implied_volatility}},
  \code{\link{american}},
  \code{\link{black_scholes_on_term_structures}},
  \code{\link{blackscholes}},
  \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility}}

Other European Options: \code{\link{black_scholes_on_term_structures}},
  \code{\link{blackscholes}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility}}

Other Implied Volatilities: \code{\link{american_implied_volatility}},
  \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{fit_variance_cumulation}},
  \code{\link{implied_jump_process_volatility}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility}}
}

