% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cashflows.R
\name{coupon_value_at_exercise}
\alias{coupon_value_at_exercise}
\title{Present value of coupons according to an acceleration schedule}
\usage{
coupon_value_at_exercise(t, coupons_df, discount_factor_fcn, model_t = 0,
  accelerate_future_coupons = FALSE,
  acceleration_discount_factor_fcn = discount_factor_fcn,
  acceleration_t = Inf)
}
\arguments{
\item{t}{The time toward which all coupons should be present valued}

\item{coupons_df}{A data.frame of details for each coupon.  It should have the
columns \code{payment_time} and \code{payment_size}.}

\item{discount_factor_fcn}{A function specifying how future cashflows should generally be discounted for this instrument}

\item{model_t}{Model timestamp passed to \code{\link{value_from_prior_coupons}}}

\item{accelerate_future_coupons}{If \code{TRUE}, future coupons will be accelerated on exercise to pad present value}

\item{acceleration_discount_factor_fcn}{A function specifying how future coupons should be discounted for this instrument under coupon acceleration conditions}

\item{acceleration_t}{The maximum time up to which future coupons will be counted for acceleration, passed on to \code{\link{accelerated_coupon_value}}}
}
\value{
A scalar equal to the present value
}
\description{
Compute "present" value as of time t for coupons that
would otherwise have been paid up to time \code{acceleration_t}, in the
case of accelerated coupon provisions for forced conversions (or
sometimes even unforced ones).
}
\seealso{
Other Bond Coupons: \code{\link{accelerated_coupon_value}},
  \code{\link{value_from_prior_coupons}}

Other Bond Coupon Acceleration: \code{\link{accelerated_coupon_value}}
}
\concept{Bond Coupon Acceleration}
\concept{Bond Coupons}
