% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revealAtte.R
\name{revealAtte}
\alias{revealAtte}
\title{Revealed Attention Analysis in Random Limited Attention Models}
\usage{
revealAtte(
  menu,
  choice,
  alternative = NULL,
  S = NULL,
  lower = TRUE,
  upper = TRUE,
  pref = NULL,
  nCritSimu = 2000,
  level = 0.95
)
}
\arguments{
\item{menu}{Numeric matrix of 0s and 1s, the collection of choice problems.}

\item{choice}{Numeric matrix of 0s and 1s, the collection of choices.}

\item{alternative}{Numeric vector, the alternatives for which to compute bounds on the
attention frequency. For example, \code{c(1, 2, 4)} means the first, second, and fourth alternatives.}

\item{S}{Numeric matrix of 0s and 1s, the collection of choice problems to compute bounds on the
attention frequency.}

\item{lower}{Boolean, whether lower bounds should be computed (default is \code{TRUE}).}

\item{upper}{Boolean, whether upper bounds should be computed (default is \code{TRUE}).}

\item{pref}{Numeric vector, corresponding to the preference. For example, \code{c(2, 3, 1)} means
2 is preferred to 3 and to 1. When set to \code{NULL}, the default, \code{c(1, 2, 3, ...)},
will be used. This option only applies to the upper bounds (i.e., when \code{upper} is set to \code{TRUE}).}

\item{nCritSimu}{Integer, number of simulations used to construct the critical value. Default is \code{2000}.}

\item{level}{Numeric, the significance level (default is \code{0.95}).}
}
\value{
\item{sumStats}{Summary statistics, generated by \code{\link{sumData}}.}
\item{lowerBound}{Matrix containing the lower bounds.}
\item{upperBound}{Matrix containing the upper bounds.}
\item{critVal}{The simulated critical value.}
\item{opt}{Options used in the function call.}
}
\description{
Given a random sample of choice problems and choices, \code{revealAtte}
  returns the upper and lower bounds on the attention frequency following the construction
  of Cattaneo, Cheung, Ma, and Masatlioglu (2021).

\code{\link{sumData}} is a low-level function that generates summary statistics. For
  revealed preference analysis, see \code{\link{revealPref}}.
}
\examples{
# Load data
data(ramdata)

# Set seed, to replicate simulated critical values
set.seed(42)

# preference
pref <- matrix(c(1, 2, 3, 4, 5), ncol=5, byrow=TRUE)
# list of choice problems
S <- matrix(c(1, 1, 0, 0, 0,
              1, 1, 1, 0, 0,
              1, 1, 1, 0, 1,
              1, 1, 1, 1, 1), ncol=5, byrow=TRUE)
result <- revealAtte(menu = ramdata$menu, choice = ramdata$choice,
  alternative = c(1,2), S = S,
  lower = TRUE, upper = TRUE,
  pref = pref)
summary(result)

}
\references{
M. D. Cattaneo, P. Cheung, X. Ma, and Y. Masatlioglu (2021). \href{https://arxiv.org/abs/2110.10650}{Attention Overload}. Working paper.

M. D. Cattaneo, X. Ma, Y. Masatlioglu, and E. Suleymanov (2020). \href{https://arxiv.org/abs/1712.03448}{A Random Attention Model}. \emph{Journal of Political Economy} 128(7): 2796-2836. \doi{10.1086/706861}
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Paul Cheung, University of Maryland. \email{hycheung@umd.edu}

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}

Yusufcan Masatlioglu, University of Maryland. \email{yusufcan@umd.edu}

Elchin Suleymanov, Purdue University. \email{esuleyma@purdue.edu}
}
