/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.learning.parametric;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataStream;
import eu.amidst.core.io.DataStreamWriter;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.utils.BayesianNetworkGenerator;
import eu.amidst.core.utils.BayesianNetworkSampler;
import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.io.DynamicDataStreamLoader;
import eu.amidst.dynamic.learning.parametric.ParallelMaximumLikelihood;
import eu.amidst.dynamic.models.DynamicBayesianNetwork;
import eu.amidst.dynamic.models.DynamicDAG;
import eu.amidst.dynamic.variables.DynamicVariables;
import java.io.IOException;

public class DynamicNaiveBayesClassifier {
    int classVarID;
    DynamicBayesianNetwork bnModel;
    boolean parallelMode = true;
    boolean connectChildrenTemporally = false;

    public boolean isParallelMode() {
        return this.parallelMode;
    }

    public void setParallelMode(boolean parallelMode) {
        this.parallelMode = parallelMode;
    }

    public boolean isConnectChildrenTemporally() {
        return this.connectChildrenTemporally;
    }

    public void setConnectChildrenTemporally(boolean connectChildrenTemporally) {
        this.connectChildrenTemporally = connectChildrenTemporally;
    }

    public int getClassVarID() {
        return this.classVarID;
    }

    public void setClassVarID(int classVarID) {
        this.classVarID = classVarID;
    }

    public DynamicBayesianNetwork getDynamicBNModel() {
        return this.bnModel;
    }

    private DynamicDAG dynamicNaiveBayesStructure(DataStream<DynamicDataInstance> dataStream) {
        DynamicVariables dynamicVariables = new DynamicVariables(dataStream.getAttributes());
        Variable classVar = dynamicVariables.getVariableById(this.getClassVarID());
        DynamicDAG dag = new DynamicDAG(dynamicVariables);
        dag.getParentSetsTimeT().stream().filter(w -> w.getMainVar().getVarID() != classVar.getVarID()).forEach(w -> {
            w.addParent(classVar);
            if (this.isConnectChildrenTemporally()) {
                w.addParent(dynamicVariables.getInterfaceVariable(w.getMainVar()));
            }
        });
        dag.getParentSetTimeT(classVar).addParent(dynamicVariables.getInterfaceVariable(classVar));
        return dag;
    }

    public void learn(DataStream<DynamicDataInstance> dataStream) {
        ParallelMaximumLikelihood parallelMaximumLikelihood = new ParallelMaximumLikelihood();
        parallelMaximumLikelihood.setDynamicDAG(this.dynamicNaiveBayesStructure(dataStream));
        parallelMaximumLikelihood.initLearning();
        parallelMaximumLikelihood.updateModel(dataStream);
        this.bnModel = parallelMaximumLikelihood.getLearntDBN();
    }

    public static void main(String[] args) throws IOException {
        BayesianNetworkGenerator.setNumberOfGaussianVars(0);
        BayesianNetworkGenerator.setNumberOfMultinomialVars(5, 2);
        BayesianNetworkGenerator.setSeed(0);
        BayesianNetwork bn = BayesianNetworkGenerator.generateNaiveBayes(2);
        int sampleSize = 1000;
        BayesianNetworkSampler sampler = new BayesianNetworkSampler(bn);
        String file = "./datasets/simulated/randomdata.arff";
        DataStream<DataInstance> dataStream = sampler.sampleToDataStream(sampleSize);
        DataStreamWriter.writeDataToFile(dataStream, file);
        DataStream<DynamicDataInstance> data = DynamicDataStreamLoader.loadFromFile(file);
        for (int i = 1; i <= 1; ++i) {
            DynamicNaiveBayesClassifier model = new DynamicNaiveBayesClassifier();
            model.setClassVarID(data.getAttributes().getNumberOfAttributes() - 1);
            model.setParallelMode(true);
            model.learn(data);
            DynamicBayesianNetwork nbClassifier = model.getDynamicBNModel();
            System.out.println(nbClassifier.toString());
        }
    }
}

