/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.utils;

import eu.amidst.core.utils.Serialization;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.models.DynamicBayesianNetwork;
import eu.amidst.dynamic.models.DynamicDAG;
import eu.amidst.dynamic.variables.DynamicVariables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DynamicBayesianNetworkGenerator {
    private static int numberOfDiscreteVars = 10;
    private static int numberOfStates = 2;
    private static int numberOfContinuousVars = 0;
    private static int numberOfLinks = 3;
    private static int seed = 0;
    private static String classVarName = "ClassVar";
    private static String discreteVarName = "DiscreteVar";
    private static String continuousVarName = "ContinuousVar";

    public static void setSeed(int seed) {
        DynamicBayesianNetworkGenerator.seed = seed;
    }

    public static void setClassVarName(String classVarName) {
        DynamicBayesianNetworkGenerator.classVarName = classVarName;
    }

    public static void setDiscreteVarName(String discreteVarName) {
        DynamicBayesianNetworkGenerator.discreteVarName = discreteVarName;
    }

    public static void setNumberOfLinks(int numberOfLinks) {
        DynamicBayesianNetworkGenerator.numberOfLinks = numberOfLinks;
    }

    public static void setNumberOfDiscreteVars(int numberOfDiscreteVars) {
        DynamicBayesianNetworkGenerator.numberOfDiscreteVars = numberOfDiscreteVars;
    }

    public static void setNumberOfContinuousVars(int numberOfContinuousVars) {
        DynamicBayesianNetworkGenerator.numberOfContinuousVars = numberOfContinuousVars;
    }

    public static void setNumberOfStates(int numberOfStates) {
        DynamicBayesianNetworkGenerator.numberOfStates = numberOfStates;
    }

    public static DynamicDAG generateDynamicNaiveBayesDAG(int numberClassStates, boolean connectChildrenTemporally) {
        DynamicVariables dynamicVariables = new DynamicVariables();
        Variable classVar = dynamicVariables.newMultinomialDynamicVariable(classVarName, numberClassStates);
        IntStream.range(1, numberOfDiscreteVars + 1).forEach(i -> dynamicVariables.newMultinomialDynamicVariable(discreteVarName + i, numberOfStates));
        IntStream.range(1, numberOfContinuousVars + 1).forEach(i -> dynamicVariables.newGaussianDynamicVariable(continuousVarName + i));
        DynamicDAG dag = new DynamicDAG(dynamicVariables);
        dag.getParentSetsTimeT().stream().filter(var -> var.getMainVar().getVarID() != classVar.getVarID()).forEach(w -> {
            w.addParent(classVar);
            if (connectChildrenTemporally) {
                w.addParent(dynamicVariables.getInterfaceVariable(w.getMainVar()));
            }
        });
        dag.getParentSetTimeT(classVar).addParent(dynamicVariables.getInterfaceVariable(classVar));
        return dag;
    }

    public static DynamicBayesianNetwork generateDynamicNaiveBayes(Random random, int numberClassStates, boolean connectChildrenTemporally) {
        DynamicBayesianNetwork network = new DynamicBayesianNetwork(DynamicBayesianNetworkGenerator.generateDynamicNaiveBayesDAG(numberClassStates, connectChildrenTemporally));
        network.randomInitialization(random);
        return network;
    }

    public static DynamicBayesianNetwork generateDynamicTAN(Random random, int numberClassStates, boolean connectChildrenTemporally) {
        DynamicBayesianNetwork dynamicNB = DynamicBayesianNetworkGenerator.generateDynamicNaiveBayes(random, numberClassStates, connectChildrenTemporally);
        DynamicVariables variables = dynamicNB.getDynamicVariables();
        DynamicDAG dynamicDAG = Serialization.deepCopy(dynamicNB.getDynamicDAG());
        int numberOfVariables = variables.getNumberOfVars();
        if (numberOfVariables > 2) {
            Variable level2Var;
            Variable treeRoot;
            while (!(treeRoot = variables.getVariableById(random.nextInt(numberOfVariables))).isMultinomial() || treeRoot.getName().equals(classVarName)) {
            }
            ArrayList<Variable> variablesLevel2 = new ArrayList<Variable>(0);
            while (!(level2Var = variables.getVariableById(random.nextInt(numberOfVariables))).isMultinomial() || level2Var.getName().equals(classVarName) || level2Var.equals(treeRoot)) {
            }
            dynamicDAG.getParentSetTime0(level2Var).addParent(treeRoot);
            dynamicDAG.getParentSetTimeT(level2Var).addParent(treeRoot);
            variablesLevel2.add(level2Var);
            for (Variable currentVar : variables) {
                Variable possibleParent;
                int currentVarLevel;
                if (currentVar.equals(treeRoot) || currentVar.getName().equals(classVarName) || currentVar.equals(level2Var)) continue;
                int aux = random.nextInt(10);
                int n = currentVarLevel = aux < 5 ? 2 : 3;
                if (currentVarLevel == 3 && variablesLevel2.size() == 0) {
                    currentVarLevel = 2;
                }
                do {
                    possibleParent = currentVarLevel == 2 ? treeRoot : (Variable)variablesLevel2.get(random.nextInt(variablesLevel2.size()));
                } while (currentVar.isMultinomial() && possibleParent.isNormal());
                dynamicDAG.getParentSetTime0(currentVar).addParent(possibleParent);
                dynamicDAG.getParentSetTimeT(currentVar).addParent(possibleParent);
                if (currentVarLevel != 2) continue;
                variablesLevel2.add(currentVar);
            }
        }
        if (dynamicDAG.toDAGTime0().containCycles() || dynamicDAG.toDAGTimeT().containCycles()) {
            System.out.println("ERROR: DAG WITH CYCLES");
            System.out.println(dynamicDAG.toString());
            System.exit(-1);
        }
        DynamicBayesianNetwork dynamicTAN = new DynamicBayesianNetwork(dynamicDAG);
        dynamicTAN.randomInitialization(random);
        return dynamicTAN;
    }

    public static DynamicBayesianNetwork generateDynamicFAN(Random random, int numberClassStates, boolean connectChildrenTemporally) {
        Variable level2Var;
        Variable level1Var;
        DynamicBayesianNetwork dynamicNB = DynamicBayesianNetworkGenerator.generateDynamicNaiveBayes(random, numberClassStates, connectChildrenTemporally);
        DynamicVariables variables = dynamicNB.getDynamicVariables();
        DynamicDAG dynamicDAG = Serialization.deepCopy(dynamicNB.getDynamicDAG());
        int numberOfVariables = variables.getNumberOfVars();
        while (!(level1Var = variables.getVariableById(random.nextInt(numberOfVariables))).isMultinomial() || level1Var.getName().equals(classVarName)) {
        }
        ArrayList<Variable> variablesLevel1 = new ArrayList<Variable>(0);
        ArrayList<Variable> variablesLevel2 = new ArrayList<Variable>(0);
        variablesLevel1.add(level1Var);
        while (!(level2Var = variables.getVariableById(random.nextInt(numberOfVariables))).isMultinomial() || level2Var.getName().equals(classVarName) || level2Var.equals(level1Var)) {
        }
        dynamicDAG.getParentSetTime0(level2Var).addParent(level1Var);
        dynamicDAG.getParentSetTimeT(level2Var).addParent(level1Var);
        variablesLevel2.add(level2Var);
        for (Variable currentVar : variables) {
            Variable possibleParent;
            int currentVarLevel;
            if (currentVar.equals(level1Var) || currentVar.getName().equals(classVarName) || currentVar.equals(level2Var)) continue;
            int aux = random.nextInt(10);
            int n = aux < 4 ? 1 : (currentVarLevel = aux < 8 ? 2 : 3);
            if (currentVarLevel == 3 && variablesLevel2.size() == 0) {
                currentVarLevel = 2;
            }
            if (currentVarLevel == 2 && variablesLevel1.size() == 0) {
                currentVarLevel = 1;
            }
            if (currentVarLevel == 1) {
                variablesLevel1.add(currentVar);
                continue;
            }
            do {
                possibleParent = currentVarLevel == 2 ? (Variable)variablesLevel1.get(random.nextInt(variablesLevel1.size())) : (Variable)variablesLevel2.get(random.nextInt(variablesLevel2.size()));
            } while (currentVar.isMultinomial() && possibleParent.isNormal());
            dynamicDAG.getParentSetTime0(currentVar).addParent(possibleParent);
            dynamicDAG.getParentSetTimeT(currentVar).addParent(possibleParent);
            if (currentVarLevel != 2) continue;
            variablesLevel2.add(currentVar);
        }
        if (dynamicDAG.toDAGTime0().containCycles() || dynamicDAG.toDAGTimeT().containCycles()) {
            System.out.println("ERROR: DAG WITH CYCLES");
            System.out.println(dynamicDAG.toString());
            System.exit(-1);
        }
        DynamicBayesianNetwork dynamicFAN = new DynamicBayesianNetwork(dynamicDAG);
        dynamicFAN.randomInitialization(random);
        return dynamicFAN;
    }

    public static DynamicDAG generateTreeDAG(DynamicVariables variables) {
        Variable var2;
        Variable var1;
        DynamicDAG dag = new DynamicDAG(variables);
        ArrayList<Object> connectedVars = new ArrayList<Object>();
        List nonConnectedVars = variables.getListOfDynamicVariables().stream().collect(Collectors.toList());
        Random random = new Random(seed);
        connectedVars.add(nonConnectedVars.remove(random.nextInt(nonConnectedVars.size())));
        while (nonConnectedVars.size() > 0) {
            var1 = (Variable)connectedVars.get(random.nextInt(connectedVars.size()));
            var2 = (Variable)nonConnectedVars.get(random.nextInt(nonConnectedVars.size()));
            if (var1.getVarID() < var2.getVarID() && dag.getParentSetTime0(var2).getNumberOfParents() == 0 && ((DistributionType)var2.getDistributionType()).isParentCompatible(var1)) {
                dag.getParentSetTime0(var2).addParent(var1);
            } else {
                if (var2.getVarID() >= var1.getVarID() || dag.getParentSetTime0(var1).getNumberOfParents() != 0 || !((DistributionType)var1.getDistributionType()).isParentCompatible(var2)) continue;
                dag.getParentSetTime0(var1).addParent(var2);
            }
            nonConnectedVars.remove(var2);
            connectedVars.add(var2);
        }
        connectedVars = new ArrayList();
        nonConnectedVars = variables.getListOfDynamicVariables().stream().collect(Collectors.toList());
        connectedVars.add(nonConnectedVars.remove(random.nextInt(nonConnectedVars.size())));
        while (nonConnectedVars.size() > 0) {
            var1 = (Variable)connectedVars.get(random.nextInt(connectedVars.size()));
            var2 = (Variable)nonConnectedVars.get(random.nextInt(nonConnectedVars.size()));
            if (var1.getVarID() < var2.getVarID() && dag.getParentSetTimeT(var2).getNumberOfParents() == 0 && ((DistributionType)var2.getDistributionType()).isParentCompatible(var1)) {
                dag.getParentSetTimeT(var2).addParent(var1);
            } else {
                if (var2.getVarID() >= var1.getVarID() || dag.getParentSetTimeT(var1).getNumberOfParents() != 0 || !((DistributionType)var1.getDistributionType()).isParentCompatible(var2)) continue;
                dag.getParentSetTimeT(var1).addParent(var2);
            }
            nonConnectedVars.remove(var2);
            connectedVars.add(var2);
        }
        return dag;
    }

    public static DynamicBayesianNetwork generateDynamicBayesianNetwork(int[] n) {
        Variable var2;
        int max;
        Object var1;
        if (n.length != numberOfDiscreteVars) {
            System.out.println("ERROR: wrong size of n[] in generateDynamicBayesianNetwork");
            System.exit(-1);
        }
        DynamicVariables variables = new DynamicVariables();
        IntStream.range(0, numberOfDiscreteVars).forEach(i -> variables.newMultinomialDynamicVariable("DiscreteVar" + i, numberOfStates + n[i]));
        IntStream.range(0, numberOfContinuousVars).forEach(i -> variables.newGaussianDynamicVariable("GaussianVar" + i));
        DynamicDAG dag = DynamicBayesianNetworkGenerator.generateTreeDAG(variables);
        Random random = new Random(seed);
        int dagLinks = variables.getNumberOfVars() - 1;
        while (dagLinks < numberOfLinks) {
            var1 = variables.getVariableById(random.nextInt(variables.getNumberOfVars()));
            max = variables.getNumberOfVars() - var1.getVarID() - 1;
            if (max == 0 || dag.getParentSetTime0(var2 = variables.getVariableById(var1.getVarID() + 1 + random.nextInt(max))).contains((Variable)var1) || !((DistributionType)var2.getDistributionType()).isParentCompatible((Variable)var1) || dag.getParentSetTime0(var2).getNumberOfParents() >= 3) continue;
            dag.getParentSetTime0(var2).addParent((Variable)var1);
            ++dagLinks;
        }
        dagLinks = variables.getNumberOfVars() - 1;
        while (dagLinks < numberOfLinks) {
            var1 = variables.getVariableById(random.nextInt(variables.getNumberOfVars()));
            max = variables.getNumberOfVars() - var1.getVarID() - 1;
            if (max == 0 || dag.getParentSetTimeT(var2 = variables.getVariableById(var1.getVarID() + 1 + random.nextInt(max))).contains((Variable)var1) || !((DistributionType)var2.getDistributionType()).isParentCompatible((Variable)var1) || dag.getParentSetTimeT(var2).getNumberOfParents() >= 3) continue;
            dag.getParentSetTimeT(var2).addParent((Variable)var1);
            ++dagLinks;
        }
        for (Variable variable : variables) {
            dag.getParentSetTimeT(variable).addParent(variable.getInterfaceVariable());
        }
        if (dag.containCycles()) {
            throw new IllegalStateException("DAG with cycles");
        }
        DynamicBayesianNetwork network = new DynamicBayesianNetwork(dag);
        network.randomInitialization(new Random(seed));
        return network;
    }

    public static DynamicBayesianNetwork generateDynamicBayesianNetwork() {
        Variable var2;
        int max;
        Object var1;
        DynamicVariables variables = new DynamicVariables();
        IntStream.range(0, numberOfDiscreteVars).forEach(i -> variables.newMultinomialDynamicVariable("DiscreteVar" + i, numberOfStates));
        IntStream.range(0, numberOfContinuousVars).forEach(i -> variables.newGaussianDynamicVariable("GaussianVar" + i));
        DynamicDAG dag = DynamicBayesianNetworkGenerator.generateTreeDAG(variables);
        Random random = new Random(seed);
        int dagLinks = variables.getNumberOfVars() - 1;
        int iter = 0;
        while (dagLinks < numberOfLinks && iter < 1000) {
            var1 = variables.getVariableById(random.nextInt(variables.getNumberOfVars()));
            max = variables.getNumberOfVars() - var1.getVarID() - 1;
            if (max == 0) continue;
            var2 = variables.getVariableById(var1.getVarID() + 1 + random.nextInt(max));
            if (dag.getParentSetTime0(var2).contains((Variable)var1) || !((DistributionType)var2.getDistributionType()).isParentCompatible((Variable)var1) || dag.getParentSetTime0(var2).getNumberOfParents() >= 3) {
                ++iter;
                continue;
            }
            dag.getParentSetTime0(var2).addParent((Variable)var1);
            ++dagLinks;
        }
        dagLinks = variables.getNumberOfVars() - 1;
        iter = 0;
        while (dagLinks < numberOfLinks && iter < 1000) {
            var1 = variables.getVariableById(random.nextInt(variables.getNumberOfVars()));
            max = variables.getNumberOfVars() - var1.getVarID() - 1;
            if (max == 0) continue;
            var2 = variables.getVariableById(var1.getVarID() + 1 + random.nextInt(max));
            if (dag.getParentSetTimeT(var2).contains((Variable)var1) || !((DistributionType)var2.getDistributionType()).isParentCompatible((Variable)var1) || dag.getParentSetTimeT(var2).getNumberOfParents() >= 3) {
                ++iter;
                continue;
            }
            dag.getParentSetTimeT(var2).addParent((Variable)var1);
            ++dagLinks;
            ++iter;
        }
        for (Variable variable : variables) {
            dag.getParentSetTimeT(variable).addParent(variable.getInterfaceVariable());
        }
        if (dag.containCycles()) {
            throw new IllegalStateException("DAG with cycles");
        }
        DynamicBayesianNetwork network = new DynamicBayesianNetwork(dag);
        network.randomInitialization(new Random(seed));
        return network;
    }

    public static void main(String[] agrs) throws IOException, ClassNotFoundException {
        DynamicBayesianNetworkGenerator.setNumberOfContinuousVars(2);
        DynamicBayesianNetworkGenerator.setNumberOfDiscreteVars(8);
        DynamicBayesianNetworkGenerator.setNumberOfStates(2);
        DynamicBayesianNetworkGenerator.setNumberOfLinks(5);
        DynamicBayesianNetwork dynamicBayesianNetwork = DynamicBayesianNetworkGenerator.generateDynamicNaiveBayes(new Random(0L), 2, true);
        System.out.println("DYNAMIC NAIVE BAYES");
        System.out.println(dynamicBayesianNetwork.getDynamicDAG().toString());
        dynamicBayesianNetwork = DynamicBayesianNetworkGenerator.generateDynamicFAN(new Random(0L), 2, true);
        System.out.println("DYNAMIC FAN");
        System.out.println(dynamicBayesianNetwork.getDynamicDAG().toString());
        dynamicBayesianNetwork = DynamicBayesianNetworkGenerator.generateDynamicTAN(new Random(0L), 2, true);
        System.out.println("DYNAMIC TAN");
        System.out.println(dynamicBayesianNetwork.getDynamicDAG().toString());
        dynamicBayesianNetwork = DynamicBayesianNetworkGenerator.generateDynamicBayesianNetwork();
        System.out.println("DYNAMIC BN");
        System.out.println(dynamicBayesianNetwork.getDynamicDAG().toString());
    }
}

