% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_importance.R
\name{plot_importance_rankings}
\alias{plot_importance_rankings}
\title{Plot importance measures rankings with ggpairs}
\usage{
plot_importance_rankings(importance_frame,
  measures = names(importance_frame)[c(2, 4, 5, 3, 7)],
  main = "Relations between rankings according to different measures")
}
\arguments{
\item{importance_frame}{A result of using the function measure_importance() to a random forest or a randomForest object}

\item{measures}{A character vector specifying the measures of importance to be used}

\item{main}{A string to be used as title of the plot}
}
\value{
A ggplot object
}
\description{
Plot against each other rankings of variables according to various measures of importance
}
\examples{
forest <- randomForest::randomForest(Species ~ ., data = iris, localImp = TRUE, ntree = 300)
frame <- measure_importance(forest, measures = c("mean_min_depth", "times_a_root"))
plot_importance_ggpairs(frame, measures = c("mean_min_depth", "times_a_root"))

}
