% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/issue.R
\name{issue}
\alias{issue}
\alias{issues}
\title{Issues in clinical trials}
\description{
Summarizes the criteria for the assessment of randomization procedures.
}
\details{
Randomization in clinical trials is supposed to
control certain issues in clinical trials.
Many of the issues are working in opposite direction, so it is crucial to decide for
which of the issues is relevant in the present clinical trial.
These issues
include
\itemize{
\item \strong{Selection bias}
		can occur if future treatment allocations are predictable due to
		restricted randomization and unmasking of past treatment assigments.
		Selection bias is represented by the \code{\link{selBias}} class.
\item \strong{Chronological bias}
		can occur if a time trend is present in the data. Time trends occur
		due to learning curves, relaxed inclusion/ exclusion criteria or
new co-medication.
		Chronological bias is represented by the \code{\link{chronBias}} class.
\item \strong{Balance}
		is important in order to ensure proper power estimation properties of
the treatments.
		However, a high degree of balance favours selection bias.
A middle course seems optimal.
		Imbalance bias is represented by the \code{\link{imbal}} class.
}
}
\seealso{
Representation of randomization procedures: \code{\link{randPar}}

Generation of randomization sequences: \code{\link{genSeq}}

Assessment of randomization sequences: \code{\link{assess}}

Comparison of randomization sequences: \code{\link{compare}}

Other issues: \code{\link{chronBias}};
  \code{\link{corGuess}}; \code{\link{imbal}};
  \code{\link{selBias}}; \code{\link{setPower}}
}

