% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chenPar.R
\name{chenPar}
\alias{chenPar}
\title{Representing Chen's Design}
\usage{
chenPar(N, mti = N, p = 0.5, groups = LETTERS[1:2])
}
\arguments{
\item{N}{integer for the total sample size of the trial.}

\item{mti}{maximum tolerated imbalance in patient numbers during the trial.}

\item{p}{success probability of the biased coin (e.g. in Efron's Biased Coin
Design).}

\item{groups}{character vector of labels for the different treatments.}
}
\value{
\code{S4} object of the class \code{chenPar}.
}
\description{
Represents the randomization procedure Chen's Design.
}
\details{
Flip a biased coin with probability \code{p} in favour of the treatment
which is allocated less frequently as long as the difference in group sizes doesn`t
exceed the \code{mti}. If the \code{mti} is reached a deterministic
allocation is done, so that the difference in group sizes is reduced.
If both treatments have been assigned equally often a fair coin is tossed.
}
\references{
Chen Yung-Pin (1999) Biased coin design with imbalance tolerance.
\emph{Comm. in Stat.}, \strong{15}, 953-975.
}
\seealso{
Other randomization procedures: \code{\link{abcdPar}},
  \code{\link{bbcdPar}}, \code{\link{bsdPar}},
  \code{\link{crPar}}, \code{\link{createParam}},
  \code{\link{ebcPar}}, \code{\link{gbcdPar}},
  \code{\link{hadaPar}}, \code{\link{mpPar}},
  \code{\link{pbrPar}}, \code{\link{rarPar}},
  \code{\link{rpbrPar}}, \code{\link{rtbdPar}},
  \code{\link{tbdPar}}, \code{\link{udPar}}
}

