% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/randomizr.r
\name{cluster_ra}
\alias{cluster_ra}
\title{Cluster Random Assignment}
\usage{
cluster_ra(clust_var, m = NULL, num_arms = NULL, m_each = NULL,
  condition_names = NULL)
}
\arguments{
\item{clust_var}{a vector of length N that describes which cluster each unit belongs to.}

\item{m}{the total number treatments to be allocated. Should only be specified for a two group design in which exactly m of N clusters is assigned to treatment. If not specified, half of the clusters will be assigned to treatment. Is null by default.}

\item{num_arms}{the total number of treatment arms. If unspecified, will be determined from the length of m_each or condition_names.}

\item{m_each}{a numeric vector giving the number of clusters to be assigned to each treatment group. Must sum to the total number of clusters. If unspecified, equally sized (rounded) groups will be assumed.}

\item{condition_names}{a character vector giving the names of the treatment groups.  If unspecified, the treatment groups will be names T1, T2, T3, etc.}
}
\description{
This function conducts complete random assignment by cluster.Clusters are collections of units that are assigned to a treatment together.
}
\examples{
# Two Group Designs
clust_var <- rep(letters, times=1:26)

Z <- cluster_ra(clust_var=clust_var)
table(Z, clust_var)

Z <- cluster_ra(clust_var=clust_var, m=13)
table(Z, clust_var)

Z <- cluster_ra(clust_var=clust_var, m_each = c(10, 16),
                condition_names = c("control", "treatment"))
table(Z, clust_var)

# Multi-arm Designs
Z <- cluster_ra(clust_var=clust_var, num_arms=3)
table(Z, clust_var)

Z <- cluster_ra(clust_var=clust_var, m_each=c(7, 7, 12))
table(Z, clust_var)

Z <- cluster_ra(clust_var=clust_var, m_each=c(7, 7, 12),
                condition_names=c("control", "placebo", "treatment"))
table(Z, clust_var)

Z <- cluster_ra(clust_var=clust_var,
                condition_names=c("control", "placebo", "treatment"))
table(Z, clust_var)
}
\keyword{assignment}
\keyword{random}

