% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{eoo}
\alias{eoo}
\title{Extent of occurrence of a species based on convex hull polygons}
\usage{
eoo(occurrences, polygons)
}
\arguments{
\item{occurrences}{a data.frame containing geographic coordinates of species
occurrences, columns must be: Species, Longitude, and Latitude. Geographic
coordinates must be in decimal degrees (WGS84).}

\item{polygons}{SpatialPolygons object to clip convex hulls to these limits.
Projection of this object defines projection of the extent of occurrence. This
projection must be one that allows safe calculation of areas (e.g., Lambert
Azimuthal Equal Area).}
}
\value{
A list containing a SpatialPolygonsDataFrame of the extent of occurrence, and
a vector with the areas in km2 of the spatial polygons resulted.
}
\description{
Extent of occurrence of a species based on convex hull polygons
}
\examples{
# occurrences
data("occ_f", package = "rangemap")
occ <- unique(occ_f)

# polygons
poly <- simple_wmap("simple", "Cuba")
LAEA <- LAEA_projection(occ[, 2:3])
poly_pr <- sp::spTransform(poly, LAEA)

# to fix topology problems
poly_pr <- rgeos::gBuffer(poly_pr, width = 0)

# EOO
eoo_pe <- eoo(occurrences = occ, polygons = poly_pr)
}
