% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ranger}
\alias{predict.ranger}
\title{Ranger prediction}
\usage{
\method{predict}{ranger}(object, data, predict.all = FALSE, seed = NULL,
  num.threads = NULL, verbose = TRUE, ...)
}
\arguments{
\item{object}{Ranger \code{ranger} object.}

\item{data}{New test data of class \code{data.frame} or \code{gwaa.data} (GenABEL).}

\item{predict.all}{Return a matrix with individual predictions for each tree instead of aggregated predictions for all trees (classification and regression only).}

\item{seed}{Random seed used in Ranger.}

\item{num.threads}{Number of threads. Default is number of CPUs available.}

\item{verbose}{Verbose output on or off.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Object of class \code{ranger.prediction} with elements
  \tabular{ll}{
      \code{predictions}    \tab Predicted classes/values (only for classification and regression)  \cr
      \code{unique.death.times} \tab Unique death times (only for survival). \cr
      \code{chf} \tab Estimated cumulative hazard function for each sample (only for survival). \cr
      \code{survival} \tab Estimated survival function for each sample (only for survival). \cr
      \code{num.trees}   \tab Number of trees. \cr
      \code{num.independent.variables} \tab Number of independent variables. \cr
      \code{treetype}    \tab Type of forest/tree. Classification, regression or survival. \cr
      \code{num.samples}     \tab Number of samples.
  }
}
\description{
Prediction with new data and a saved forest from Ranger.
}
\details{
For classification and predict.all = TRUE, a matrix of factor levels is returned. 
To retrieve the corresponding factor levels, use rf$forest$levels, if rf is the ranger object.
}
\author{
Marvin N. Wright
}
\seealso{
\code{\link{ranger}}
}

