% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar.R
\name{PlotBar}
\alias{PlotBar}
\title{Illustrate bar chart of treatment ranking metrics}
\usage{
PlotBar(data, accum = NULL, merge = NULL, color = NULL)
}
\arguments{
\item{data}{DATA of metrics for treatment ranking.}

\item{accum}{LOGIC value for indicating whether use accumulative probabilities.
This parameter is only for probabilities but not global metrics of
treatment ranking.}

\item{merge}{LOGIC value for indicating whether merge bar charts together.}

\item{color}{LIST of colors for treatments in a network meta-analysis,
or CHARACTER of a color for the bar on not accumulated bar chart.}
}
\value{
\strong{PlotBar()} returns a bar chart.
}
\description{
\strong{PlotBar()} is a function for illustrating bar chart in both separated and
accumulative styles.
}
\examples{
## Not run:
#library(netmeta)
#data(Senn2013)
#nma <- netmeta(TE, seTE, treat1, treat2,
#studlab, data = Senn2013, sm = "SMD")

# Get SUCRA
#dataMetrics <- GetMetrics(nma, outcome = "HbA1c", prefer = "small", metrics = "SUCRA",
#model = "random", simt = 1000)

# Set data for rankinma
#dataRankinma <- SetMetrics(dataMetrics, tx = tx, outcome = outcome,
#metrics = SUCRA, metrics.name = "SUCRA")

# Illustrate bar plot
#PlotBar(dataRankinma)
## End(Not run)

}
\references{
Van Valkenhoef, G., Tervonen, T., Zwinkels, T., De Brock, B., &
Hillege, H. (2013). ADDIS: a decision support system for evidence-based
medicine. \strong{Decision Support Systems}, \emph{55(2)}, 459-475.
}
\seealso{
\code{\link{GetMetrics}}, \code{\link{SetMetrics}},
\code{\link{PlotBeads}}, \code{\link{PlotLine}},
\code{\link{PlotHeat}}, \code{\link{PlotSpie}}
}
\author{
Enoch Kang
}
