% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GreedyLocal.R
\name{GreedyLocal}
\alias{GreedyLocal}
\title{Estimate the MLE of a Mallows-Binomial distribution using the GreedyLocal method}
\usage{
GreedyLocal(Pi, X, M)
}
\arguments{
\item{Pi}{Matrix of partial or complete rankings, one row per ranking.}

\item{X}{Matrix of ratings, one row per judge and one column per object.}

\item{M}{Numeric specifying maximum (=worst quality) integer rating.}
}
\value{
List with elements pi0 (estimated consensus ranking MLE),  p (estimated object quality parameter MLE), theta (estimated scale parameter MLE), and numnodes (number of nodes traversed during algorithm, a measure of computational complexity).
}
\description{
This function estimates the MLE of a Mallows-Binomial distribution using the GreedyLocal method, as described in Pearce and Erosheva (2022). The method is identical to the Greedy method but includes an automatic and targeted post-hoc local search.
}
\examples{
Pi <- matrix(c(1,2,3,4,2,1,NA,NA),byrow=TRUE,nrow=2)
X <- matrix(c(0,1,2,3,1,2,2,5),byrow=TRUE,nrow=2)
GreedyLocal(Pi=Pi,X=X,M=5)
 
}
